/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;

public class SyntaxActions {
    public static PairAction LPARAN = new PairAction("LPARAN", "(", ")");
    public static PairAction LSQUARE = new PairAction("LSQUARE", "[", "]");
    public static PairAction DQUOTE = new PairAction("DQUOTE", "\"", "\"");
    public static PairAction SQUOTE = new PairAction("SQUOTE", "'", "'");
    public static SmartIndent SMART_INDENT = new SmartIndent();
    public static JavaIndent JAVA_INDENT = new JavaIndent();
    public static IndentAction INDENT = new IndentAction();
    public static UnindentAction UNINDENT = new UnindentAction();
    public static UndoAction UNDO = new UndoAction();
    public static RedoAction REDO = new RedoAction();
    private static final Map<String, Keymap> KEYMAP_MAP = new HashMap<String, Keymap>();
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private static String SPACES = "                ";

    private static String getIndent(String line) {
        int i;
        if (line == null || line.length() == 0) {
            return "";
        }
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return line.substring(0, i);
    }

    private static String[] getSelectedLines(JTextComponent target) {
        String[] lines = null;
        try {
            PlainDocument pDoc = (PlainDocument)target.getDocument();
            int start = pDoc.getParagraphElement(target.getSelectionStart()).getStartOffset();
            int end = target.getSelectionStart() == target.getSelectionEnd() ? pDoc.getParagraphElement(target.getSelectionEnd()).getEndOffset() : pDoc.getParagraphElement(target.getSelectionEnd() - 1).getEndOffset();
            target.select(start, end);
            lines = pDoc.getText(start, end - start).split("\n");
            target.select(start, end);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(SyntaxActions.class.getName()).log(Level.SEVERE, null, ex);
            lines = EMPTY_STRING_ARRAY;
        }
        return lines;
    }

    private static String getLine(JTextComponent target) {
        PlainDocument pDoc = (PlainDocument)target.getDocument();
        return SyntaxActions.getLineAt(pDoc, target.getCaretPosition());
    }

    private static String getLineAt(PlainDocument doc, int pos) {
        String line = null;
        int start = doc.getParagraphElement(pos).getStartOffset();
        int end = doc.getParagraphElement(pos).getEndOffset();
        try {
            line = doc.getText(start, end - start);
            if (line != null && line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(SyntaxActions.class.getName()).log(Level.SEVERE, null, ex);
        }
        return line;
    }

    private static String getCaretToken(SyntaxDocument doc, int pos) {
        String word = "";
        Token t = doc.getTokenAt(pos);
        if (t != null) {
            try {
                word = doc.getText(t.start, t.length);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(SyntaxActions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return word;
    }

    private static Keymap getKeymap(String lang) {
        Keymap km = KEYMAP_MAP.get(lang);
        if (km == null) {
            km = JTextComponent.addKeymap(null, JTextComponent.getKeymap("default"));
            KEYMAP_MAP.put(lang, km);
        }
        return km;
    }

    @Deprecated
    public static void addAction(String lang, JTextComponent control, Character key, TextAction action) {
        Keymap km = SyntaxActions.getKeymap(lang);
        km.addActionForKeyStroke(KeyStroke.getKeyStroke(key.charValue()), action);
        if (control.getKeymap() != km) {
            control.setKeymap(km);
        }
    }

    @Deprecated
    public static void addAction(JTextComponent control, KeyStroke stroke, TextAction action) {
        control.getKeymap().addActionForKeyStroke(stroke, action);
    }

    @Deprecated
    public static void addAction(String lang, JTextComponent control, String stroke, TextAction action) {
        KeyStroke ks = KeyStroke.getKeyStroke(stroke);
        if (ks == null) {
            throw new IllegalArgumentException("invalid keystroke: " + stroke);
        }
        Keymap km = SyntaxActions.getKeymap(lang);
        km.addActionForKeyStroke(ks, action);
        if (km != control.getKeymap()) {
            control.setKeymap(km);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapCompleteAction
    extends TextAction {
        Map<String, String> completions;

        public MapCompleteAction(Map<String, String> completions) {
            super("MAP_COMPLETION");
            this.completions = completions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String abbriv;
            int dot;
            SyntaxDocument sDoc;
            Token token;
            JTextComponent target = this.getTextComponent(e);
            if (target != null && target.getDocument() instanceof SyntaxDocument && (token = (sDoc = (SyntaxDocument)target.getDocument()).getTokenAt(dot = target.getCaretPosition())) != null && this.completions.containsKey(abbriv = SyntaxActions.getCaretToken(sDoc, dot))) {
                try {
                    String completed = this.completions.get(abbriv);
                    if (completed.indexOf(124) >= 0) {
                        int ofst = completed.length() - completed.indexOf(124) - 1;
                        sDoc.replace(token.start, token.length, completed.replace("|", ""), null);
                        target.setCaretPosition(target.getCaretPosition() - ofst);
                    } else {
                        sDoc.replace(token.start, token.length, completed, null);
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(SyntaxActions.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static class RedoAction
    extends TextAction {
        public RedoAction() {
            super("REDO");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null && target.getDocument() instanceof SyntaxDocument) {
                SyntaxDocument sDoc = (SyntaxDocument)target.getDocument();
                sDoc.doRedo();
            }
        }
    }

    public static class UndoAction
    extends TextAction {
        public UndoAction() {
            super("UNDO");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null && target.getDocument() instanceof SyntaxDocument) {
                SyntaxDocument sDoc = (SyntaxDocument)target.getDocument();
                sDoc.doUndo();
            }
        }
    }

    public static class UnindentAction
    extends TextAction {
        public UnindentAction() {
            super("UNINDENT");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            Integer tabStop = (Integer)target.getDocument().getProperty("tabSize");
            String indent = SPACES.substring(0, tabStop);
            if (target != null) {
                String[] lines = SyntaxActions.getSelectedLines(target);
                int start = target.getSelectionStart();
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    if (line.startsWith(indent)) {
                        sb.append(line.substring(indent.length()));
                    } else if (line.startsWith("\t")) {
                        sb.append(line.substring(1));
                    } else {
                        sb.append(line);
                    }
                    sb.append('\n');
                }
                target.replaceSelection(sb.toString());
                target.select(start, start + sb.length());
            }
        }
    }

    public static class IndentAction
    extends DefaultEditorKit.InsertTabAction {
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                String selected = target.getSelectedText();
                if (selected == null) {
                    PlainDocument pDoc = (PlainDocument)target.getDocument();
                    Integer tabStop = (Integer)pDoc.getProperty("tabSize");
                    int lineStart = pDoc.getParagraphElement(target.getCaretPosition()).getStartOffset();
                    int column = target.getCaretPosition() - lineStart;
                    int needed = tabStop - column % tabStop;
                    target.replaceSelection(SPACES.substring(0, needed));
                } else {
                    String[] lines = SyntaxActions.getSelectedLines(target);
                    int start = target.getSelectionStart();
                    StringBuilder sb = new StringBuilder();
                    for (String line : lines) {
                        sb.append('\t');
                        sb.append(line);
                        sb.append('\n');
                    }
                    target.replaceSelection(sb.toString());
                    target.select(start, start + sb.length());
                }
            }
        }
    }

    public static class JavaIndent
    extends TextAction {
        public JavaIndent() {
            super("JAVA_INDENT");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                String line = SyntaxActions.getLine(target);
                String prefix = SyntaxActions.getIndent(line);
                Integer tabSize = (Integer)target.getDocument().getProperty("tabSize");
                if (line.trim().endsWith("{")) {
                    prefix = prefix + SPACES.substring(0, tabSize);
                }
                target.replaceSelection("\n" + prefix);
            }
        }
    }

    public static class SmartIndent
    extends TextAction {
        public SmartIndent() {
            super("SMART_INDENT");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                String line = SyntaxActions.getLine(target);
                target.replaceSelection("\n" + SyntaxActions.getIndent(line));
            }
        }
    }

    public static class PairAction
    extends TextAction {
        String left;
        String right;

        public PairAction(String actionName, String left, String right) {
            super(actionName);
            this.left = left;
            this.right = right;
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                String selected = target.getSelectedText();
                if (selected != null) {
                    target.replaceSelection(this.left + selected + this.right);
                } else {
                    target.replaceSelection(this.left + this.right);
                }
                target.setCaretPosition(target.getCaretPosition() - 1);
            }
        }
    }
}

