/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import jsyntaxpane.Lexer;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.util.JarServiceProvider;

public class DefaultSyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static Font DEFAULT_FONT;
    private Lexer lexer;
    private static Logger LOG;

    public DefaultSyntaxKit(Lexer lexer) {
        this.lexer = lexer;
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public View create(Element element) {
        return new SyntaxView(element);
    }

    public void install(JEditorPane editorPane) {
        super.install(editorPane);
        editorPane.setFont(DEFAULT_FONT);
        if (this.lexer != null) {
            this.lexer.install(editorPane);
        }
    }

    public Document createDefaultDocument() {
        return new SyntaxDocument(this.lexer);
    }

    public static void initKit() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] fonts = ge.getAvailableFontFamilyNames();
        Arrays.sort(fonts);
        if (Arrays.binarySearch(fonts, "Courier new") >= 0) {
            DEFAULT_FONT = new Font("Courier New", 0, 12);
        } else if (Arrays.binarySearch(fonts, "Courier") >= 0) {
            DEFAULT_FONT = new Font("Courier", 0, 12);
        } else if (Arrays.binarySearch(fonts, "Monospaced") >= 0) {
            DEFAULT_FONT = new Font("Monospaced", 0, 13);
        }
        Properties kitsForTypes = JarServiceProvider.readProperties("jsyntaxpane.kitsfortypes");
        for (String type : kitsForTypes.stringPropertyNames()) {
            String kitForType = kitsForTypes.getProperty(type);
            JEditorPane.registerEditorKitForContentType(type, kitForType);
        }
    }

    static {
        LOG = Logger.getLogger(DefaultSyntaxKit.class.getName());
        DefaultSyntaxKit.initKit();
    }
}

