/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IExpressionString;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Result;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class OpLIKE
implements IExpressionString {
    private static final char[] escRegExChars = new char[]{'^', '$', '.', '[', ']', '{', '}', '*', '?', '+', '(', ')', '|'};
    private final IExpression lhs_;
    private final IExpression esc_;
    private final IExpression pattern_;
    private final Pattern compiledPattern_;

    public OpLIKE(IExpression lhs, IExpression pattern, IExpression escape) {
        char escChar;
        this.lhs_ = lhs;
        this.pattern_ = pattern;
        this.esc_ = escape;
        if (this.esc_ == null) {
            escChar = '\u0000';
        } else {
            String esc = ((String)this.esc_.eval(null)).trim();
            if (esc.length() != 1) {
                throw new IllegalStateException("ESCAPE pattern must be one character: ;" + esc + "'");
            }
            escChar = esc.charAt(0);
        }
        try {
            this.compiledPattern_ = OpLIKE.compilePattern((String)pattern.eval(null), escChar);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalStateException("Invalid match pattern: " + pattern);
        }
    }

    public Object eval(Map identifiers) {
        Object oLhs = this.lhs_.eval(identifiers);
        if (!(oLhs instanceof String)) {
            return Result.RESULT_UNKNOWN;
        }
        return this.compiledPattern_.matcher((String)oLhs).matches() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
    }

    public Object eval(IValueProvider provider, Object corr) {
        Object oLhs = this.lhs_.eval(provider, corr);
        if (!(oLhs instanceof String)) {
            return Result.RESULT_UNKNOWN;
        }
        return this.compiledPattern_.matcher((String)oLhs).matches() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
    }

    public String toString() {
        if (this.esc_ != null) {
            return String.valueOf(this.lhs_.toString()) + " LIKE '" + this.pattern_.toString() + "'";
        }
        return String.valueOf(this.lhs_.toString()) + " LIKE '" + this.pattern_.toString() + "' ESCAPE '" + this.esc_.toString() + "'";
    }

    private static Pattern compilePattern(String pattern, char cEsc) {
        String regExp = null;
        if (cEsc == '\u0000') {
            regExp = pattern.replaceAll("_", ".{1}").replaceAll("%", ".*");
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < pattern.length()) {
                char nextChar = pattern.charAt(i);
                if (nextChar != cEsc) {
                    String s = OpLIKE.toAppendString(nextChar);
                    if (s != null) {
                        buf.append(s);
                    } else {
                        buf.append(nextChar);
                    }
                } else {
                    buf.append('\\');
                    if (++i < pattern.length()) {
                        buf.append(pattern.charAt(i));
                    }
                }
                ++i;
            }
            regExp = buf.toString();
        }
        return Pattern.compile(regExp);
    }

    private static String toAppendString(char c) {
        if (c == '_') {
            return ".{1}";
        }
        if (c == '%') {
            return ".*";
        }
        int i = 0;
        while (i < escRegExChars.length) {
            if (c == escRegExChars[i]) {
                return "\\" + c;
            }
            ++i;
        }
        return null;
    }
}

