/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.toolkit;

import de.nava.informa.utils.poller.PriorityComparator;
import de.nava.informa.utils.toolkit.ChannelRecord;
import de.nava.informa.utils.toolkit.WorkerThread;
import de.nava.informa.utils.toolkit.WorkerThreadFactoryIF;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.BinaryHeap;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;

public class WorkersManager {
    private static final int DEFAULT_WORKER_THREADS = 5;
    private static final int DEFAULT_QUEUE_LIMIT = 25;
    private List<WorkerThread> workers = new ArrayList<WorkerThread>();
    private Buffer queue = BufferUtils.blockingBuffer((Buffer)new BinaryHeap(25, (Comparator)new PriorityComparator()));
    private WorkerThreadFactoryIF workerThreadsFactory;

    public WorkersManager(WorkerThreadFactoryIF factory) {
        this(factory, 5);
    }

    public WorkersManager(WorkerThreadFactoryIF factory, int workerThreads) {
        this.workerThreadsFactory = factory;
        if (workerThreads <= 0) {
            workerThreads = 5;
        }
        this.setWorkerThreads(workerThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWorkerThreads(int count) {
        List<WorkerThread> list = this.workers;
        synchronized (list) {
            WorkerThread worker;
            int i;
            int curWorkerThreads = this.workers.size();
            for (i = curWorkerThreads - 1; i >= count; --i) {
                worker = this.workers.get(i);
                worker.terminate();
                this.workers.remove(worker);
            }
            for (i = curWorkerThreads = this.workers.size(); i < count; ++i) {
                worker = this.workerThreadsFactory.create();
                worker.setQueue(this.queue);
                this.workers.add(worker);
                worker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminateAll() {
        List<WorkerThread> list = this.workers;
        synchronized (list) {
            int count = this.workers.size();
            for (int i = count - 1; i >= 0; --i) {
                this.workers.get(i).terminate();
                this.workers.remove(i);
            }
        }
    }

    public final void process(ChannelRecord record) {
        if (!this.isInProcess(record)) {
            this.putRecordInQueue(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInProcess(ChannelRecord record) {
        boolean found = false;
        List<WorkerThread> list = this.workers;
        synchronized (list) {
            Iterator<WorkerThread> i = this.workers.iterator();
            while (!found && i.hasNext()) {
                WorkerThread worker = i.next();
                found = worker.getChannelInProcess() == record;
            }
        }
        return found;
    }

    private void putRecordInQueue(ChannelRecord record) {
        this.queue.add((Object)record);
    }
}

