/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.poller;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.UnsupportedFormatException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.FormatDetector;
import de.nava.informa.utils.HttpHeaderUtils;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.poller.InputSourceProviderIF;
import de.nava.informa.utils.poller.InputStreamProviderIF;
import de.nava.informa.utils.poller.PollerApproverIF;
import de.nava.informa.utils.poller.PollerObserverIF;
import de.nava.informa.utils.toolkit.ChannelRecord;
import de.nava.informa.utils.toolkit.WorkerThread;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import org.xml.sax.InputSource;

public class PollerWorkerThread
extends WorkerThread {
    private static final ChannelBuilderIF BUILDER = new ChannelBuilder();
    public static final int POLICY_SKIP_AFTER_EXISTING = 1;
    public static final int POLICY_SCAN_ALL = 2;
    private static int seq = 1;
    private PollerObserverIF observer;
    private PollerApproverIF approver;
    private int itemScanningPolicy;
    private String userAgent;
    private InputSourceProviderIF inputSourceProvider;
    private InputStreamProviderIF inputStreamProvider;

    public PollerWorkerThread(PollerObserverIF observer, PollerApproverIF approver, int itemScanningPolicy, InputSourceProviderIF inputSourceProvider, InputStreamProviderIF inputStreamProvider) {
        super("Poller " + seq++);
        this.observer = observer;
        this.approver = approver;
        this.itemScanningPolicy = itemScanningPolicy;
        this.inputSourceProvider = inputSourceProvider;
        this.inputStreamProvider = inputStreamProvider;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected final void processRecord(ChannelRecord record) {
        ChannelIF channel = record.getChannel();
        this.observer.pollStarted(channel);
        try {
            if (!record.isFormatResolved()) {
                this.resolveFormat(record);
            }
            this.checkContents(record);
            this.observer.pollFinished(channel);
        }
        catch (Exception e) {
            this.observer.channelErrored(channel, e);
        }
    }

    private void resolveFormat(ChannelRecord record) throws IOException, UnsupportedFormatException {
        ChannelIF channel = record.getChannel();
        InputStream in = this.getInputStream(channel, "Detecting format");
        if (in != null) {
            try {
                channel.setFormat(FormatDetector.getFormat(in));
                record.setFormatResolved(true);
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }

    private InputStream getInputStream(ChannelIF channel, String activity) throws IOException {
        return this.inputStreamProvider != null ? this.inputStreamProvider.getInputStreamFor(channel, activity) : this.getInputStream(channel.getLocation());
    }

    private InputStream getInputStream(URL location) throws IOException {
        if (location == null) {
            return null;
        }
        URLConnection connection = location.openConnection();
        if (this.userAgent != null && connection instanceof HttpURLConnection) {
            HttpHeaderUtils.setUserAgent((HttpURLConnection)connection, this.userAgent);
        }
        return new BufferedInputStream(connection.getInputStream());
    }

    private void checkContents(ChannelRecord record) throws IOException, ParseException {
        ChannelIF channel = record.getChannel();
        URL baseUrl = channel.getLocation();
        InputStream in = this.getInputStream(channel, "Fetching");
        if (in != null) {
            try {
                ChannelIF tempChannel = FeedParser.parse(BUILDER, this.createInputSource(in), baseUrl);
                if (!record.isCanceled() && PollerWorkerThread.channelHasChanged(channel, tempChannel)) {
                    InformaUtils.copyChannelProperties(tempChannel, channel);
                    this.observer.channelChanged(channel);
                }
                if (!record.isCanceled()) {
                    this.checkItems(tempChannel, record);
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }

    private InputSource createInputSource(InputStream feedInputStream) throws IOException {
        return this.inputSourceProvider == null ? new InputSource(feedInputStream) : this.inputSourceProvider.getInputSourceFor(feedInputStream);
    }

    final void checkItems(ChannelIF newChannel, ChannelRecord record) {
        ChannelIF existingChannel = record.getChannel();
        Set<ItemIF> items = newChannel.getItems();
        ItemIF[] newItems = items.toArray(new ItemIF[items.size()]);
        Set<ItemIF> currentItems = existingChannel.getItems();
        boolean finish = false;
        for (int i = 0; !record.isCanceled() && !finish && i < newItems.length; ++i) {
            ItemIF newItem = newItems[i];
            if (!record.isCanceled() && !currentItems.contains(newItem)) {
                this.doAdditionIfApproved(newItem, existingChannel);
                continue;
            }
            if (this.itemScanningPolicy != 1) continue;
            finish = true;
        }
    }

    private void doAdditionIfApproved(ItemIF newItem, ChannelIF existingChannel) {
        boolean approved = false;
        try {
            approved = this.approver.canAddItem(newItem, existingChannel);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (approved) {
            try {
                this.observer.itemFound(newItem, existingChannel);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    static boolean channelHasChanged(ChannelIF o, ChannelIF n) {
        return o == null || PollerWorkerThread.differ(o.getTitle(), n.getTitle()) || PollerWorkerThread.differ(o.getDescription(), n.getDescription()) || PollerWorkerThread.differ(o.getSite(), n.getSite()) || PollerWorkerThread.differ(o.getCreator(), n.getCreator()) || PollerWorkerThread.differ(o.getCopyright(), n.getCopyright()) || PollerWorkerThread.differ(o.getPublisher(), n.getPublisher()) || PollerWorkerThread.differ(o.getLanguage(), n.getLanguage()) || PollerWorkerThread.differ(o.getRating(), n.getRating()) || PollerWorkerThread.differ(o.getGenerator(), n.getGenerator()) || PollerWorkerThread.differ(o.getDocs(), n.getDocs()) || o.getTtl() != n.getTtl() || PollerWorkerThread.differ(o.getUpdateBase(), n.getUpdateBase()) || o.getUpdateFrequency() != n.getUpdateFrequency() || o.getUpdatePeriod() != n.getUpdatePeriod() || PollerWorkerThread.differ(o.getPubDate(), n.getPubDate()) || PollerWorkerThread.differ((Object)o.getFormat(), (Object)n.getFormat());
    }

    static boolean differ(Object a, Object b) {
        return !(a == null && b == null || a instanceof URL && b instanceof URL && a.toString().equals(b.toString()) || a != null && a.equals(b));
    }
}

