/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.poller;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.poller.CompositeApprover;
import de.nava.informa.utils.poller.CompositeObserver;
import de.nava.informa.utils.poller.InputSourceProviderIF;
import de.nava.informa.utils.poller.InputStreamProviderIF;
import de.nava.informa.utils.poller.PollerApproverIF;
import de.nava.informa.utils.poller.PollerObserverIF;
import de.nava.informa.utils.poller.PollerWorkerThread;
import de.nava.informa.utils.toolkit.ChannelRecord;
import de.nava.informa.utils.toolkit.Scheduler;
import de.nava.informa.utils.toolkit.SchedulerCallbackIF;
import de.nava.informa.utils.toolkit.WorkerThread;
import de.nava.informa.utils.toolkit.WorkerThreadFactoryIF;
import de.nava.informa.utils.toolkit.WorkersManager;

public class Poller {
    private static final long DEFAULT_POLL_PERIOD = 3600000L;
    private static final int DEFAULT_WORKER_THREADS = 5;
    public static final int POLICY_SKIP_AFTER_EXISTING = 1;
    public static final int POLICY_SCAN_ALL = 2;
    private WorkersManager workersManager;
    private Scheduler scheduler;
    private CompositeObserver compositeObserver = new CompositeObserver();
    private CompositeApprover compositeApprover = new CompositeApprover();
    private long globalPollPeriod = 3600000L;
    private int itemScanningPolicy;
    private String userAgent;
    private InputSourceProviderIF inputSourceProvider;
    private InputStreamProviderIF inputStreamProvider;

    public Poller() {
        this(5);
    }

    public Poller(int workerThreads) {
        this(workerThreads, 2);
    }

    public Poller(int workerThreads, int itemScanningPolicy) {
        this(workerThreads, itemScanningPolicy, null);
    }

    public Poller(int workerThreads, int itemScanningPolicy, String userAgent) {
        this(workerThreads, itemScanningPolicy, userAgent, null, null);
    }

    public Poller(int workerThreads, int itemScanningPolicy, String userAgent, InputSourceProviderIF inputSourceProvider, InputStreamProviderIF inputStreamProvider) {
        this.itemScanningPolicy = itemScanningPolicy;
        this.userAgent = userAgent;
        this.inputSourceProvider = inputSourceProvider;
        this.inputStreamProvider = inputStreamProvider;
        this.workersManager = new WorkersManager(new PollerThreadFactory(), workerThreads);
        this.scheduler = new Scheduler(new SchedulerCallback());
    }

    public final void setWorkerThreads(int count) {
        this.workersManager.setWorkerThreads(count);
    }

    public final void registerChannel(ChannelIF channel) {
        if (channel != null) {
            this.scheduler.schedule(channel, this.globalPollPeriod, 0);
        }
    }

    public final void registerChannel(ChannelIF channel, long period) {
        if (channel != null) {
            this.scheduler.schedule(channel, period, 0);
        }
    }

    public final void registerChannel(ChannelIF channel, long delay, long period) {
        if (channel != null) {
            this.scheduler.schedule(channel, delay, period, 0);
        }
    }

    public final void updateChannel(ChannelIF channel) {
        if (channel != null) {
            this.scheduler.triggerNow(channel);
        }
    }

    public final void unregisterChannel(ChannelIF channel) {
        if (channel != null) {
            this.scheduler.unschedule(channel);
        }
    }

    public final void addObserver(PollerObserverIF observer) {
        this.compositeObserver.add(observer);
    }

    public final void removeObserver(PollerObserverIF observer) {
        this.compositeObserver.remove(observer);
    }

    public final void addApprover(PollerApproverIF approver) {
        this.compositeApprover.add(approver);
    }

    public final void removeApprover(PollerApproverIF approver) {
        this.compositeApprover.remove(approver);
    }

    public final void setPeriod(long period) {
        this.globalPollPeriod = period;
        this.scheduler.rescheduleAll(period);
    }

    private class PollerThreadFactory
    implements WorkerThreadFactoryIF {
        private PollerThreadFactory() {
        }

        public WorkerThread create() {
            PollerWorkerThread workerThread = new PollerWorkerThread(Poller.this.compositeObserver, Poller.this.compositeApprover, Poller.this.itemScanningPolicy, Poller.this.inputSourceProvider, Poller.this.inputStreamProvider);
            if (Poller.this.userAgent != null) {
                workerThread.setUserAgent(Poller.this.userAgent);
            }
            return workerThread;
        }
    }

    private class SchedulerCallback
    implements SchedulerCallbackIF {
        private SchedulerCallback() {
        }

        public void process(ChannelRecord record) {
            Poller.this.workersManager.process(record);
        }
    }
}

