/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.manager.memory;

import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.basic.ItemGuid;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import de.nava.informa.utils.manager.memory.Channel;
import de.nava.informa.utils.manager.memory.ChannelGroup;
import de.nava.informa.utils.manager.memory.IdGenerator;
import de.nava.informa.utils.manager.memory.Item;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class PersistenceManager
implements PersistenceManagerIF {
    private Map<Long, ChannelGroup> groups = new HashMap<Long, ChannelGroup>();
    private Map<Long, Channel> channels = new HashMap<Long, Channel>();
    private Map<Long, Item> items = new HashMap<Long, Item>();

    public final ChannelGroupIF createGroup(String title) {
        long id = IdGenerator.getNextId();
        ChannelGroup group = new ChannelGroup(id, title);
        this.groups.put(new Long(id), group);
        return group;
    }

    public void updateGroup(ChannelGroupIF group) {
    }

    public final void deleteGroup(ChannelGroupIF group) {
        group.getAll().clear();
        this.groups.remove(new Long(group.getId()));
        group.setId(-1L);
    }

    public final void mergeGroups(ChannelGroupIF first, ChannelGroupIF second) {
        this.moveChannels(second, first);
        this.deleteGroup(second);
    }

    public final ChannelGroupIF[] getGroups() {
        return this.groups.values().toArray(new ChannelGroupIF[0]);
    }

    public final ChannelIF createChannel(String title, URL location) {
        long id = IdGenerator.getNextId();
        Channel channel = new Channel(id, title, location);
        this.channels.put(new Long(id), channel);
        return channel;
    }

    public void updateChannel(ChannelIF channel) {
    }

    public final void addChannelToGroup(ChannelIF channel, ChannelGroupIF group) {
        if (!group.getAll().contains(channel)) {
            group.add(channel);
        }
        if (channel instanceof Channel) {
            ((Channel)channel).addParentGroup(group);
        }
    }

    public final void removeChannelFromGroup(ChannelIF channel, ChannelGroupIF group) {
        group.remove(channel);
        if (channel instanceof Channel) {
            ((Channel)channel).removeParentGroup(group);
        }
    }

    public final void deleteChannel(ChannelIF channel) {
        int i;
        if (channel instanceof Channel) {
            ChannelGroupIF[] groupsList = ((Channel)channel).getParentGroups();
            for (i = 0; i < groupsList.length; ++i) {
                ChannelGroupIF group = groupsList[i];
                this.removeChannelFromGroup(channel, group);
            }
        }
        ItemIF[] itemsList = channel.getItems().toArray(new ItemIF[0]);
        for (i = 0; i < itemsList.length; ++i) {
            this.deleteItem(itemsList[i]);
        }
        this.channels.remove(new Long(channel.getId()));
        channel.setId(-1L);
    }

    public final ItemIF createItem(ChannelIF channel, String title) {
        long id = IdGenerator.getNextId();
        Item item = new Item(id, title, channel);
        this.items.put(new Long(item.getId()), item);
        if (channel.getItems().contains(item)) {
            channel.removeItem(item);
        }
        channel.addItem(item);
        return item;
    }

    public final ItemIF createItem(ChannelIF channel, ItemIF ethalon) {
        ItemIF item = this.createItem(channel, ethalon.getTitle());
        InformaUtils.copyItemProperties(ethalon, item);
        ItemGuidIF ethalonGuid = ethalon.getGuid();
        if (ethalonGuid != null) {
            item.setGuid(new ItemGuid(item, ethalonGuid.getLocation(), ethalonGuid.isPermaLink()));
        }
        return item;
    }

    public void updateItem(ItemIF item) {
    }

    public final void deleteItem(ItemIF item) {
        if (item instanceof Item) {
            ChannelIF parent = ((Item)item).getParent();
            parent.removeItem(item);
        }
        this.items.remove(new Long(item.getId()));
        item.setId(-1L);
    }

    final void moveChannels(ChannelGroupIF src, ChannelGroupIF dest) {
        ChannelIF[] secondChannels = src.getAll().toArray(new ChannelIF[0]);
        for (int i = 0; i < secondChannels.length; ++i) {
            ChannelIF channel = secondChannels[i];
            this.addChannelToGroup(channel, dest);
            this.removeChannelFromGroup(channel, src);
        }
    }
}

