/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.cleaner;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.cleaner.CleanerObserverIF;
import java.util.List;
import java.util.Vector;

class CompositeObserver
implements CleanerObserverIF {
    private List<CleanerObserverIF> observers = new Vector<CleanerObserverIF>();

    CompositeObserver() {
    }

    public void unwantedItem(ItemIF item, ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            CleanerObserverIF observer = this.observers.get(i);
            try {
                observer.unwantedItem(item, channel);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void cleaningStarted(ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            CleanerObserverIF observer = this.observers.get(i);
            try {
                observer.cleaningStarted(channel);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void cleaningFinished(ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            CleanerObserverIF observer = this.observers.get(i);
            try {
                observer.cleaningFinished(channel);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public final void add(CleanerObserverIF observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public final void remove(CleanerObserverIF observer) {
        this.observers.remove(observer);
    }
}

