/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.cleaner;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.cleaner.CleanerMatcherIF;
import de.nava.informa.utils.cleaner.CleanerObserverIF;
import de.nava.informa.utils.toolkit.ChannelRecord;
import de.nava.informa.utils.toolkit.WorkerThread;

public class CleanerWorkerThread
extends WorkerThread {
    private static int seq = 1;
    private CleanerObserverIF observer;
    private CleanerMatcherIF matcher;

    public CleanerWorkerThread(CleanerObserverIF observer, CleanerMatcherIF matcher) {
        super("Cleaner " + seq++);
        this.observer = observer;
        this.matcher = matcher;
    }

    protected final void processRecord(ChannelRecord record) {
        if (this.matcher != null && this.observer != null) {
            ChannelIF channel = record.getChannel();
            this.observer.cleaningStarted(channel);
            ItemIF[] items = channel.getItems().toArray(new ItemIF[0]);
            for (int i = 0; i < items.length; ++i) {
                this.checkItem(items[i], channel);
            }
            this.observer.cleaningFinished(channel);
        }
    }

    private void checkItem(ItemIF item, ChannelIF channel) {
        if (this.matcher.isMatching(item, channel)) {
            try {
                this.observer.unwantedItem(item, channel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

