/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

public class UpdateChannelInfo {
    private int nrProblemsOccurred;
    private int deactivateAfterErrors;
    private boolean formatDetected = false;
    private Exception lastException;
    private long lastUpdatedTimestamp = -1L;

    public UpdateChannelInfo(int deactivateAfterErrors) {
        this.deactivateAfterErrors = deactivateAfterErrors;
        this.reset();
    }

    public int getNrProblemsOccurred() {
        return this.nrProblemsOccurred;
    }

    public int getDeactivateAfterErrors() {
        return this.deactivateAfterErrors;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void reset() {
        this.nrProblemsOccurred = 0;
        this.lastException = null;
    }

    public synchronized void increaseProblemsOccurred(Exception e) {
        this.lastException = e;
        ++this.nrProblemsOccurred;
    }

    public boolean shouldDeactivate() {
        if (this.deactivateAfterErrors < 1) {
            return false;
        }
        return this.nrProblemsOccurred >= this.deactivateAfterErrors;
    }

    public boolean getFormatDetected() {
        return this.formatDetected;
    }

    public void setFormatDetected(boolean formatDetected) {
        this.formatDetected = formatDetected;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(42);
        sb.append("nr probs occurred: ").append(this.nrProblemsOccurred).append(", deactivate after ").append(this.deactivateAfterErrors).append(", format detected: ").append(this.formatDetected);
        if (this.lastException != null) {
            sb.append(", last exception: ").append(this.lastException.getMessage());
        }
        return sb.toString();
    }

    public long getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public void setLastUpdatedTimestamp(long lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }
}

