/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderException;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelBuilder;
import de.nava.informa.impl.hibernate.ChannelGroup;
import de.nava.informa.impl.hibernate.Item;
import de.nava.informa.impl.hibernate.SessionHandler;
import de.nava.informa.utils.PersistChanGrpMgrObserverIF;
import de.nava.informa.utils.PersistChanGrpMgrTask;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class PersistChanGrpMgr {
    private static final int DEFAULT_STARTDELAY = 1000;
    private static final int DEFAULT_PERIOD = 600000;
    private static final int DEFAULT_ACCEPTERRORS = 10;
    private static final int DBG_DEFAULT_STARTDELAY = 100;
    private static final int DBG_DEFAULT_PERIOD = 20000;
    private static final int DBG_DEFAULT_ACCEPTERRORS = 10;
    private static Log logger = LogFactory.getLog(PersistChanGrpMgr.class);
    private ChannelBuilder builder;
    private ChannelGroup group;
    private SessionHandler handler;
    private PersistChanGrpMgrObserverIF globalChannelObserver;
    private boolean activated = false;
    private PersistChanGrpMgrTask task;
    private int pollingCounter;
    int taskStartDelay;
    int taskPeriod;
    int acceptNrErrors;

    public PersistChanGrpMgr(SessionHandler handler, boolean debug) {
        if (handler == null) {
            throw new IllegalStateException("Invalid handler");
        }
        this.handler = handler;
        this.builder = new ChannelBuilder(handler);
        this.pollingCounter = 0;
        if (debug) {
            this.taskStartDelay = 100;
            this.taskPeriod = 20000;
            this.acceptNrErrors = 10;
        } else {
            this.taskStartDelay = 1000;
            this.taskPeriod = 600000;
            this.acceptNrErrors = 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelGroup createGroup(String name) {
        logger.debug((Object)("Creating Persistent Group: " + name));
        if (this.group != null) {
            throw new IllegalStateException("Can't call createGroup twice in a row.");
        }
        if (this.activated) {
            throw new IllegalStateException("Can't create groups while activated.");
        }
        ChannelGroup result = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            result = this.findChannelGroup(name);
            if (result == null) {
                try {
                    this.builder.beginTransaction();
                    result = (ChannelGroup)this.builder.createChannelGroup(name);
                    this.builder.endTransaction();
                }
                catch (ChannelBuilderException e) {
                    try {
                        this.builder.endTransaction();
                    }
                    catch (ChannelBuilderException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
            this.group = result;
        }
        logger.info((Object)("createGroup(\"" + name + "\" yielded: " + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup() {
        if (this.group == null) {
            return;
        }
        logger.debug((Object)("Deleting Persistent Group: " + this.group.getTitle()));
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(this.group);
                Channel[] chans = this.group.getChannels().toArray(new Channel[0]);
                for (int i = 0; i < chans.length; ++i) {
                    Channel chan = chans[i];
                    Set<ChannelGroup> grps = chan.getGroups();
                    grps.remove(this.group);
                    this.group.getChannels().remove(chan);
                    if (grps.size() != 0) continue;
                    this.builder.delete(chan);
                }
                this.builder.delete(this.group);
                this.builder.endTransaction();
                this.group = null;
            }
            catch (ChannelBuilderException e) {
                logger.error((Object)("Unable to delete Persistent Group: " + e.getMessage()));
                this.builder.resetTransaction();
            }
        }
    }

    public boolean hasChannel(Channel achannel) {
        return this.group.getChannels().contains(achannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel addChannel(String url) {
        if (this.activated) {
            throw new IllegalStateException("can't add Channels while activated.");
        }
        Channel achannel = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(this.group);
                achannel = this.findChannel(url);
                if (achannel == null) {
                    achannel = this.newChannel(url);
                    logger.debug((Object)("Added New Channel: " + url));
                } else if (!this.hasChannel(achannel)) {
                    logger.debug((Object)("Loaded existing channel" + url));
                    this.group.add(achannel);
                    achannel.getGroups().add(this.group);
                }
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
            return achannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChannelTo(Channel channel, PersistChanGrpMgr destGrp) {
        if (this.activated || destGrp.isActivated()) {
            throw new IllegalStateException("can't move Channels while activated.");
        }
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(this.group);
                this.builder.reload(channel);
                ChannelGroup dstGroup = this.builder.reload(destGrp.getChannelGroup());
                this.group.remove(channel);
                channel.getGroups().remove(this.group);
                dstGroup.add(channel);
                channel.getGroups().add(dstGroup);
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteChannel(Channel channel) {
        boolean result = false;
        if (this.activated) {
            throw new IllegalStateException("can't delete Channels while activated.");
        }
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(this.group);
                this.builder.reload(channel);
                if (this.hasChannel(channel)) {
                    this.group.remove(channel);
                    channel.getGroups().remove(this.group);
                    this.builder.delete(channel);
                    result = true;
                }
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteItemFromChannel(Channel channel, Item item) {
        if (this.activated) {
            throw new IllegalStateException("can't delete Items while activated");
        }
        int result = 0;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(channel);
                this.builder.reload(item);
                channel.removeItem(item);
                this.builder.delete(item);
                result = channel.getItems().size();
                this.builder.endTransaction();
            }
            catch (ChannelBuilderException e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount(Channel channel) {
        if (this.activated) {
            throw new IllegalStateException("can't count Items while activated");
        }
        int result = 0;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(channel);
                result = channel.getItems().size();
                this.builder.endTransaction();
            }
            catch (ChannelBuilderException e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChannelsAndItems(Channel channel) {
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(channel);
                this.notifyChannelRetrieved(channel);
                this.notifyItems(channel);
                this.builder.endTransaction();
            }
            catch (ChannelBuilderException e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
        }
    }

    public void notifyItems(Channel channelHandle) {
        if (this.globalChannelObserver != null) {
            Iterator<ItemIF> iterChan = channelHandle.getItems().iterator();
            while (iterChan.hasNext()) {
                this.notifyItemAdded((Item)iterChan.next());
            }
        }
    }

    public void notifyChannelsAndItems() {
        Iterator<ChannelIF> chanIter = this.group.getChannels().iterator();
        while (chanIter.hasNext()) {
            this.notifyChannelsAndItems((Channel)chanIter.next());
        }
    }

    public void notifyChannels() {
        Iterator chanIter = this.channelIterator();
        while (chanIter.hasNext()) {
            this.notifyChannelRetrieved((Channel)chanIter.next());
        }
    }

    public void notifyChannelRetrieved(Channel chan) {
        if (this.globalChannelObserver != null) {
            try {
                this.globalChannelObserver.channelRetrieved(chan);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyItemAdded(Item newItem) {
        if (this.globalChannelObserver != null) {
            try {
                this.globalChannelObserver.itemAdded(newItem);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyPolling(boolean isPolling) {
        if (this.globalChannelObserver != null) {
            try {
                this.globalChannelObserver.pollingNow(this.group.getTitle(), this.pollingCounter, isPolling);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setGlobalObserver(PersistChanGrpMgrObserverIF obser) {
        this.globalChannelObserver = obser;
    }

    public synchronized void activate() {
        if (this.activated) {
            return;
        }
        this.task = new PersistChanGrpMgrTask(this, this.taskPeriod);
        this.task.start();
        this.activated = true;
    }

    public boolean isActivated() {
        return this.activated || this.task != null && this.task.isRunning();
    }

    public void incrPollingCounter() {
        ++this.pollingCounter;
    }

    public int getPollingCounter() {
        return this.pollingCounter;
    }

    public synchronized void deActivate() {
        this.deActivate(false);
    }

    public synchronized void deActivate(boolean waitForFinish) {
        if (this.task != null) {
            logger.debug((Object)("deActivate(" + this.task.getName() + ") " + this.activated));
        } else {
            logger.debug((Object)"deActivate task = null");
        }
        if (!this.activated) {
            return;
        }
        this.task.interrupt(waitForFinish);
        this.activated = false;
    }

    public void setParams(int startDel, int period, int acceptErr) {
        if (this.activated) {
            throw new IllegalStateException("can't setParams while activated");
        }
        if (startDel != -1) {
            this.taskStartDelay = startDel;
        }
        if (period != -1) {
            this.taskPeriod = period;
        }
        if (acceptErr != -1) {
            this.acceptNrErrors = acceptErr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator channelIterator() {
        Iterator<ChannelIF> ret = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(this.group);
                ret = this.group.getAll().iterator();
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public ChannelBuilder getBuilder() {
        return this.builder;
    }

    public ChannelGroup getChannelGroup() {
        return this.group;
    }

    public SessionHandler getHandler() {
        return this.handler;
    }

    public int getAcceptNrErrors() {
        return this.acceptNrErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result = "";
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.reload(this.group);
                result = this.group.getTitle() + "[" + this.group.getChannels().size() + "]";
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel newChannel(String url) {
        Channel channel;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            channel = (Channel)this.builder.createChannel("[uninitialized channel]");
        }
        channel.setLocationString(url);
        this.group.add(channel);
        channel.getGroups().add(this.group);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel findChannel(String url) {
        Channel achan = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            Session sess = this.builder.getSession();
            try {
                Query q = sess.createQuery("from Channel chan where chan.locationString = :url order by chan.id desc");
                q.setParameter("url", (Object)url, (Type)Hibernate.STRING);
                List channels = q.list();
                int size = channels.size();
                if (size > 0) {
                    if (size > 1) {
                        logger.error((Object)("Multiple Channels for " + url + " found."));
                    }
                    achan = (Channel)channels.get(0);
                }
            }
            catch (HibernateException e) {
                achan = null;
                e.printStackTrace();
            }
        }
        logger.info((Object)("findChannel: " + url + "->" + achan));
        return achan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelGroup findChannelGroup(String name) {
        ChannelGroup result = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                Session sess = this.builder.getSession();
                Query q = sess.createQuery("from ChannelGroup as grp where grp.title = :title");
                q.setParameter("title", (Object)name, (Type)Hibernate.STRING);
                List results = q.list();
                int size = results.size();
                if (size > 0) {
                    if (size > 1) {
                        logger.error((Object)("Multiple Channel Groups called " + name + " found."));
                    }
                    result = (ChannelGroup)results.get(0);
                }
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
        }
        logger.info((Object)("findChannelGroup: " + name + "->" + result));
        return result;
    }
}

