/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileUtils {
    private static Log logger = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    public static boolean compare(String nameExpected, String nameActual) throws IOException {
        return FileUtils.compare(new File(nameExpected), new File(nameActual));
    }

    public static boolean compare(File fileExpected, File fileActual) throws IOException {
        BufferedReader readExpected;
        try {
            logger.debug((Object)("Comparing golden file " + fileExpected + " to " + fileActual));
            readExpected = new BufferedReader(new FileReader(fileExpected));
        }
        catch (IOException e) {
            logger.error((Object)("Could not read baseline: " + e));
            return false;
        }
        BufferedReader readActual = new BufferedReader(new FileReader(fileActual));
        return FileUtils.compare(readExpected, readActual);
    }

    private static boolean compare(BufferedReader readerExpected, BufferedReader readerActual) throws IOException {
        String lineExpected = readerExpected.readLine();
        String lineActual = readerActual.readLine();
        while (lineExpected != null && lineActual != null) {
            if (lineExpected == null || lineActual == null) {
                return false;
            }
            if (!lineExpected.equals(lineActual)) {
                return false;
            }
            lineExpected = readerExpected.readLine();
            lineActual = readerActual.readLine();
        }
        readerExpected.close();
        readerActual.close();
        return lineExpected == null && lineActual == null;
    }

    public static void copyFile(File inFile, File outFile) {
        try {
            int n;
            logger.debug((Object)("Copying file " + inFile + " to " + outFile));
            FileInputStream in = new FileInputStream(inFile);
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buf = new byte[8192];
            while ((n = ((InputStream)in).read(buf)) >= 0) {
                ((OutputStream)out).write(buf, 0, n);
                out.flush();
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            logger.warn((Object)("Error occurred while copying file " + inFile + " to " + outFile));
            e.printStackTrace();
        }
    }
}

