/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.utils.FeedManagerEntry;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedRefreshDaemon {
    private static Log logger = LogFactory.getLog(FeedRefreshDaemon.class);
    private Timer refreshTimer = null;

    public FeedRefreshDaemon() {
        logger.info((Object)"FeedRefresh Daemon instancied");
        this.refreshTimer = new Timer(true);
    }

    public void addFeed(FeedManagerEntry feed) {
        FeedRefreshTask refreshTask = new FeedRefreshTask();
        refreshTask.setFeedME(feed);
        logger.info((Object)"scheduling new feed ");
        Date fiveMinuteLater = new Date(new Date().getTime() + 300000L);
        this.refreshTimer.schedule((TimerTask)refreshTask, fiveMinuteLater, 300000L);
    }

    private class FeedRefreshTask
    extends TimerTask {
        FeedManagerEntry f = null;
        int nbError = 0;

        private FeedRefreshTask() {
        }

        public void setFeedME(FeedManagerEntry feedME) {
            this.f = feedME;
        }

        public void run() {
            try {
                this.f.getFeed();
                logger.debug((Object)("feed refreshed" + this.f.getFeed().getLocation()));
            }
            catch (Exception e) {
                ++this.nbError;
                logger.warn((Object)("Error retrieving feed" + this.f.toString() + " " + e));
            }
        }
    }
}

