/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelParserIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.utils.ParserUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

class RSS_1_0_Parser
implements ChannelParserIF {
    private static Log logger = LogFactory.getLog(RSS_1_0_Parser.class);

    private RSS_1_0_Parser() {
    }

    public static RSS_1_0_Parser getInstance() {
        return RSS_1_0_ParserHolder.instance;
    }

    public ChannelIF parse(ChannelBuilderIF cBuilder, Element root) throws ParseException {
        Element txtinp;
        Element updateBase;
        Element updateFrequency;
        Element updatePeriod;
        Attribute generator;
        Element elGenerator;
        Element lastBuildDate;
        Element rating;
        Element copyright;
        Element elErrorReportsTo;
        String publisher;
        Namespace dcNS;
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        Date dateParsed = new Date();
        Namespace defNS = ParserUtils.getDefaultNS(root);
        if (defNS == null) {
            defNS = Namespace.NO_NAMESPACE;
            logger.info((Object)"No default namespace found.");
        }
        if ((dcNS = ParserUtils.getNamespace(root, "dc")) == null) {
            dcNS = defNS;
        }
        Namespace syNS = ParserUtils.getNamespace(root, "sy");
        Namespace agNS = ParserUtils.getNamespace(root, "ag");
        Namespace adminNS = ParserUtils.getNamespace(root, "admin");
        Namespace dctermsNS = ParserUtils.getNamespace(root, "dcterms");
        Namespace annotateNS = ParserUtils.getNamespace(root, "annotate");
        Namespace rss091NS = ParserUtils.getNamespace(root, "rss091");
        Namespace contentNS = ParserUtils.getNamespace(root, "content");
        ParserUtils.matchCaseOfChildren(root, new String[]{"channel", "item", "image", "textinput"});
        Element channel = root.getChild("channel", defNS);
        if (channel == null) {
            logger.warn((Object)"Channel element could not be retrieved from feed.");
            throw new ParseException("No channel element found in feed.");
        }
        ParserUtils.matchCaseOfChildren(channel, new String[]{"title", "description", "link", "creator", "managingEditor", "publisher", "errorReportsTo", "webMaster", "language", "rights", "copyright", "rating", "date", "issued", "pubdate", "lastBuildDate", "modified", "generatorAgent", "updatePeriod", "updateFrequency", "updateBase"});
        ChannelIF chnl = cBuilder.createChannel(channel, channel.getChildTextTrim("title", defNS));
        chnl.setFormat(ChannelFormat.RSS_1_0);
        chnl.setDescription(channel.getChildTextTrim("description", defNS));
        chnl.setSite(ParserUtils.getURL(channel.getChildTextTrim("link", defNS)));
        Element creator = channel.getChild("creator", dcNS);
        if (creator == null) {
            creator = channel.getChild("managingEditor", rss091NS);
        }
        if (creator != null) {
            chnl.setCreator(creator.getTextTrim());
        }
        if ((publisher = channel.getChildTextTrim("publisher", dcNS)) == null && (elErrorReportsTo = channel.getChild("errorReportsTo", adminNS)) != null) {
            publisher = elErrorReportsTo.getAttributeValue("resource", ParserUtils.getNamespace(elErrorReportsTo, "rdf"));
        }
        if (publisher == null) {
            publisher = channel.getChildTextTrim("webMaster", rss091NS);
        }
        chnl.setPublisher(publisher);
        Element language = channel.getChild("language", dcNS);
        if (language == null) {
            language = channel.getChild("language", rss091NS);
        }
        if (language != null) {
            chnl.setLanguage(language.getTextTrim());
        }
        if ((copyright = channel.getChild("rights", dcNS)) == null) {
            copyright = channel.getChild("copyright", rss091NS);
        }
        if (copyright != null) {
            chnl.setCopyright(copyright.getTextTrim());
        }
        if ((rating = channel.getChild("rating", rss091NS)) != null) {
            chnl.setRating(rating.getTextTrim());
        }
        chnl.setDocs(defNS.getURI());
        Element pubDate = channel.getChild("date", dcNS);
        if (pubDate == null) {
            pubDate = channel.getChild("issued", dctermsNS);
        }
        if (pubDate == null) {
            pubDate = channel.getChild("pubdate", rss091NS);
        }
        if (pubDate != null) {
            chnl.setPubDate(ParserUtils.getDate(pubDate.getTextTrim()));
        }
        if ((lastBuildDate = channel.getChild("lastBuildDate")) == null) {
            lastBuildDate = channel.getChild("modified", dctermsNS);
        }
        if (lastBuildDate == null) {
            lastBuildDate = channel.getChild("lastBuildDate", rss091NS);
        }
        if (lastBuildDate != null) {
            chnl.setLastBuildDate(ParserUtils.getDate(lastBuildDate.getTextTrim()));
        }
        if ((elGenerator = channel.getChild("generatorAgent", adminNS)) != null && (generator = elGenerator.getAttribute("resource", ParserUtils.getNamespace(elGenerator, "rdf"))) != null) {
            chnl.setGenerator(generator.getValue());
        }
        if ((updatePeriod = channel.getChild("updatePeriod", syNS)) != null) {
            try {
                ChannelUpdatePeriod channelUpdatePeriod = ChannelUpdatePeriod.valueFromText(updatePeriod.getTextTrim());
                chnl.setUpdatePeriod(channelUpdatePeriod);
            }
            catch (IllegalArgumentException ex) {
                logger.warn((Object)updatePeriod.getTextTrim(), (Throwable)ex);
            }
        }
        if ((updateFrequency = channel.getChild("updateFrequency", syNS)) != null) {
            chnl.setUpdateFrequency(new Integer(updateFrequency.getTextTrim()));
        }
        if ((updateBase = channel.getChild("updateBase", syNS)) != null) {
            chnl.setUpdateBase(ParserUtils.getDate(updateBase.getTextTrim()));
        }
        if (updatePeriod != null && updateFrequency != null) {
            int ttl = this.getTTL(chnl.getUpdatePeriod(), chnl.getUpdateFrequency());
            chnl.setTtl(ttl);
        }
        List items = root.getChildren("item", defNS);
        for (Element item : items) {
            URL resourceURL;
            Attribute resource;
            Element elReference;
            Element elDate;
            Element elSubject;
            Element elDesc;
            ParserUtils.matchCaseOfChildren(item, new String[]{"title", "link", "encoded", "description", "creator", "subject", "date", "sourceURL", "source", "timestamp", "reference"});
            Element elTitle = item.getChild("title", defNS);
            String strTitle = "<No Title>";
            if (elTitle != null) {
                strTitle = elTitle.getTextTrim();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Item element found (" + strTitle + ")."));
            }
            Element elLink = item.getChild("link", defNS);
            String strLink = "";
            if (elLink != null) {
                strLink = elLink.getTextTrim();
            }
            if ((elDesc = item.getChild("encoded", contentNS)) == null) {
                elDesc = item.getChild("description", defNS);
            }
            if (elDesc == null) {
                elDesc = item.getChild("description", dcNS);
            }
            String strDesc = "";
            if (elDesc != null) {
                strDesc = elDesc.getTextTrim();
            }
            ItemIF rssItem = cBuilder.createItem(item, chnl, strTitle, strDesc, ParserUtils.getURL(strLink));
            rssItem.setFound(dateParsed);
            Element elCreator = item.getChild("creator", dcNS);
            if (elCreator != null) {
                rssItem.setCreator(elCreator.getTextTrim());
            }
            if ((elSubject = item.getChild("subject", dcNS)) != null) {
                rssItem.setSubject(elSubject.getTextTrim());
            }
            if ((elDate = item.getChild("date", dcNS)) != null) {
                rssItem.setDate(ParserUtils.getDate(elDate.getTextTrim()));
            }
            String sourceName = null;
            String sourceLocation = null;
            Date sourceTimestamp = null;
            Element elSourceURL = item.getChild("sourceURL", agNS);
            if (elSourceURL == null) {
                elSourceURL = item.getChild("source", dcNS);
                if (elSourceURL != null) {
                    sourceLocation = elSourceURL.getTextTrim();
                    sourceName = "Source";
                }
            } else {
                Element elSourceTimestamp;
                sourceLocation = elSourceURL.getTextTrim();
                Element elSourceName = item.getChild("source", agNS);
                if (elSourceName != null) {
                    sourceName = elSourceName.getTextTrim();
                }
                if ((elSourceTimestamp = item.getChild("timestamp", agNS)) != null) {
                    sourceTimestamp = ParserUtils.getDate(elSourceTimestamp.getTextTrim());
                }
            }
            if (sourceLocation != null) {
                ItemSourceIF itemSource = cBuilder.createItemSource(rssItem, sourceName, sourceLocation, sourceTimestamp);
                rssItem.setSource(itemSource);
            }
            if ((elReference = item.getChild("reference", annotateNS)) == null || (resource = elReference.getAttribute("resource", ParserUtils.getNamespace(elReference, "rdf"))) == null || (resourceURL = ParserUtils.getURL(resource.getValue())) == null) continue;
            rssItem.setComments(resourceURL);
        }
        Element image = root.getChild("image", defNS);
        if (image != null) {
            Element imgDescr;
            Element imgHeight;
            ParserUtils.matchCaseOfChildren(image, new String[]{"title", "url", "link", "width", "height", "description"});
            ImageIF rssImage = cBuilder.createImage(image.getChildTextTrim("title", defNS), ParserUtils.getURL(image.getChildTextTrim("url", defNS)), ParserUtils.getURL(image.getChildTextTrim("link", defNS)));
            Element imgWidth = image.getChild("width", defNS);
            if (imgWidth != null) {
                try {
                    rssImage.setWidth(Integer.parseInt(imgWidth.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            if ((imgHeight = image.getChild("height", defNS)) != null) {
                try {
                    rssImage.setHeight(Integer.parseInt(imgHeight.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            if ((imgDescr = image.getChild("description", defNS)) != null) {
                rssImage.setDescription(imgDescr.getTextTrim());
            }
            chnl.setImage(rssImage);
        }
        if ((txtinp = root.getChild("textinput", defNS)) != null) {
            ParserUtils.matchCaseOfChildren(image, new String[]{"title", "description", "name", "link"});
            String tiTitle = null;
            if (txtinp.getChild("title", defNS) != null) {
                tiTitle = txtinp.getChild("title", defNS).getTextTrim();
            }
            String tiDescr = null;
            if (txtinp.getChild("description", defNS) != null) {
                tiDescr = txtinp.getChild("description", defNS).getTextTrim();
            }
            String tiName = null;
            if (txtinp.getChild("name", defNS) != null) {
                tiName = txtinp.getChild("name", defNS).getTextTrim();
            }
            URL tiLink = null;
            if (txtinp.getChild("link", defNS) != null) {
                tiLink = ParserUtils.getURL(txtinp.getChild("link", defNS).getTextTrim());
            }
            TextInputIF rssTextInput = cBuilder.createTextInput(tiTitle, tiDescr, tiName, tiLink);
            chnl.setTextInput(rssTextInput);
        }
        chnl.setLastUpdated(dateParsed);
        return chnl;
    }

    private int getTTL(ChannelUpdatePeriod updatePeriod, int updateFrequency) {
        int minutes = updatePeriod != null ? updatePeriod.getMinutesInPeriod() : 1440;
        return updateFrequency == 0 ? minutes : minutes / updateFrequency;
    }

    private static class RSS_1_0_ParserHolder {
        private static RSS_1_0_Parser instance = new RSS_1_0_Parser();

        private RSS_1_0_ParserHolder() {
        }
    }
}

