/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelParserIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.utils.ParserUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;

class RSS_0_91_Parser
implements ChannelParserIF {
    private static Log logger = LogFactory.getLog(RSS_0_91_Parser.class);

    private RSS_0_91_Parser() {
    }

    public static RSS_0_91_Parser getInstance() {
        return RSS_0_91_ParserHolder.instance;
    }

    public ChannelIF parse(ChannelBuilderIF cBuilder, Element root) throws ParseException {
        Element cloud;
        Element webMaster;
        Element managingEditor;
        Element docs;
        Element lastBuildDate;
        Element pubDate;
        Element rating;
        Element copyright;
        Element txtinp;
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        Date dateParsed = new Date();
        logger.debug((Object)"start parsing.");
        ParserUtils.matchCaseOfChildren(root, "channel");
        Element channel = root.getChild("channel");
        if (channel == null) {
            logger.warn((Object)"Channel element could not be retrieved from feed.");
            throw new ParseException("No channel element found in feed.");
        }
        ParserUtils.matchCaseOfChildren(channel, new String[]{"title", "description", "link", "language", "item", "image", "textinput", "copyright", "rating", "pubDate", "lastBuildDate", "docs", "managingEditor", "webMaster", "cloud"});
        ChannelIF chnl = cBuilder.createChannel(channel, channel.getChildTextTrim("title"));
        chnl.setFormat(ChannelFormat.RSS_0_91);
        chnl.setDescription(channel.getChildTextTrim("description"));
        chnl.setSite(ParserUtils.getURL(channel.getChildTextTrim("link")));
        chnl.setLanguage(channel.getChildTextTrim("language"));
        List items = channel.getChildren("item");
        for (Element item : items) {
            Attribute lengthAttribute;
            Attribute typeAttribute;
            Element enclosure;
            ParserUtils.matchCaseOfChildren(item, new String[]{"title", "link", "description", "source", "enclosure"});
            Element elTitle = item.getChild("title");
            String strTitle = "<No Title>";
            if (elTitle != null) {
                strTitle = elTitle.getTextTrim();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Item element found (" + strTitle + ")."));
            }
            Element elLink = item.getChild("link");
            String strLink = "";
            if (elLink != null) {
                strLink = elLink.getTextTrim();
            }
            Element elDesc = item.getChild("description");
            String strDesc = "";
            if (elDesc != null) {
                strDesc = elDesc.getTextTrim();
            }
            ItemIF rssItem = cBuilder.createItem(item, chnl, strTitle, strDesc, ParserUtils.getURL(strLink));
            rssItem.setFound(dateParsed);
            Element source = item.getChild("source");
            if (source != null) {
                String sourceName = source.getTextTrim();
                Attribute sourceAttribute = source.getAttribute("url");
                if (sourceAttribute != null) {
                    String location = sourceAttribute.getValue().trim();
                    ItemSourceIF itemSource = cBuilder.createItemSource(rssItem, sourceName, location, null);
                    rssItem.setSource(itemSource);
                }
            }
            if ((enclosure = item.getChild("enclosure")) == null) continue;
            URL location = null;
            String type = null;
            int length = -1;
            Attribute urlAttribute = enclosure.getAttribute("url");
            if (urlAttribute != null) {
                location = ParserUtils.getURL(urlAttribute.getValue().trim());
            }
            if ((typeAttribute = enclosure.getAttribute("type")) != null) {
                type = typeAttribute.getValue().trim();
            }
            if ((lengthAttribute = enclosure.getAttribute("length")) != null) {
                try {
                    length = Integer.parseInt(lengthAttribute.getValue().trim());
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            ItemEnclosureIF itemEnclosure = cBuilder.createItemEnclosure(rssItem, location, type, length);
            rssItem.setEnclosure(itemEnclosure);
        }
        Element image = channel.getChild("image");
        if (image != null) {
            Element imgDescr;
            Element imgHeight;
            ParserUtils.matchCaseOfChildren(image, new String[]{"title", "url", "link", "width", "height", "description"});
            ImageIF rssImage = cBuilder.createImage(image.getChildTextTrim("title"), ParserUtils.getURL(image.getChildTextTrim("url")), ParserUtils.getURL(image.getChildTextTrim("link")));
            Element imgWidth = image.getChild("width");
            if (imgWidth != null) {
                try {
                    rssImage.setWidth(Integer.parseInt(imgWidth.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            if ((imgHeight = image.getChild("height")) != null) {
                try {
                    rssImage.setHeight(Integer.parseInt(imgHeight.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            if ((imgDescr = image.getChild("description")) != null) {
                rssImage.setDescription(imgDescr.getTextTrim());
            }
            chnl.setImage(rssImage);
        }
        if ((txtinp = channel.getChild("textinput")) != null) {
            ParserUtils.matchCaseOfChildren(txtinp, new String[]{"title", "description", "name", "link"});
            TextInputIF rssTextInput = cBuilder.createTextInput(txtinp.getChild("title").getTextTrim(), txtinp.getChild("description").getTextTrim(), txtinp.getChild("name").getTextTrim(), ParserUtils.getURL(txtinp.getChild("link").getTextTrim()));
            chnl.setTextInput(rssTextInput);
        }
        if ((copyright = channel.getChild("copyright")) != null) {
            chnl.setCopyright(copyright.getTextTrim());
        }
        if ((rating = channel.getChild("rating")) != null) {
            chnl.setRating(rating.getTextTrim());
        }
        if ((pubDate = channel.getChild("pubDate")) != null) {
            chnl.setPubDate(ParserUtils.getDate(pubDate.getTextTrim()));
        }
        if ((lastBuildDate = channel.getChild("lastBuildDate")) != null) {
            chnl.setLastBuildDate(ParserUtils.getDate(lastBuildDate.getTextTrim()));
        }
        if ((docs = channel.getChild("docs")) != null) {
            chnl.setDocs(docs.getTextTrim());
        }
        if ((managingEditor = channel.getChild("managingEditor")) != null) {
            chnl.setCreator(managingEditor.getTextTrim());
        }
        if ((webMaster = channel.getChild("webMaster")) != null) {
            chnl.setPublisher(webMaster.getTextTrim());
        }
        if ((cloud = channel.getChild("cloud")) != null) {
            String _port = cloud.getAttributeValue("port");
            int port = -1;
            if (_port != null) {
                try {
                    port = Integer.parseInt(_port);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            chnl.setCloud(cBuilder.createCloud(cloud.getAttributeValue("domain"), port, cloud.getAttributeValue("path"), cloud.getAttributeValue("registerProcedure"), cloud.getAttributeValue("protocol")));
        }
        chnl.setLastUpdated(dateParsed);
        return chnl;
    }

    private static class RSS_0_91_ParserHolder {
        private static RSS_0_91_Parser instance = new RSS_0_91_Parser();

        private RSS_0_91_ParserHolder() {
        }
    }
}

