/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelParserIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.utils.AtomParserUtils;
import de.nava.informa.utils.ParserUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

class Atom_0_3_Parser
implements ChannelParserIF {
    public static final Log LOGGER = LogFactory.getLog(Atom_0_3_Parser.class);

    private Atom_0_3_Parser() {
    }

    public static Atom_0_3_Parser getInstance() {
        return Atom_0_3_ParserHolder.instance;
    }

    static String getValue(Element elt) {
        return AtomParserUtils.getValue(elt, elt.getAttributeValue("mode"));
    }

    static String getContent(Element elt) {
        if (elt == null) {
            return "";
        }
        String value = Atom_0_3_Parser.getValue(elt);
        String type = Atom_0_3_Parser.getContentType(elt);
        if ("text/plain".equals(type)) {
            value = ParserUtils.escape(value);
        }
        return value;
    }

    private static String getContentType(Element elt) {
        String type = elt.getAttributeValue("type");
        return type == null ? "text/plain" : type;
    }

    static String getCopyright(Element elt) {
        return Atom_0_3_Parser.getTitle(elt);
    }

    public static String getDescription(Element item, Namespace namespace) {
        String strDesc = "";
        List contents = item.getChildren("content", namespace);
        Element elDesc = contents.size() > 0 ? (Element)contents.get(0) : item.getChild("summary", namespace);
        if (elDesc != null) {
            strDesc = Atom_0_3_Parser.getValue(elDesc);
        }
        return strDesc;
    }

    static String getTitle(Element elt) {
        String value;
        if (elt == null) {
            return "";
        }
        String type = Atom_0_3_Parser.getContentType(elt);
        if ("application/xhtml+xml".equals(type)) {
            value = elt.getValue();
        } else {
            value = AtomParserUtils.getValue(elt, elt.getAttributeValue("mode"));
            if (!"text/plain".equals(type)) {
                value = ParserUtils.unEscape(value);
            }
        }
        return value;
    }

    public ChannelIF parse(ChannelBuilderIF cBuilder, Element channel) throws ParseException {
        Element copyright;
        Element generator;
        Element author;
        Element modified;
        String ttlString;
        Namespace dcNS;
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        Date dateParsed = new Date();
        Namespace defNS = ParserUtils.getDefaultNS(channel);
        if (defNS == null) {
            defNS = Namespace.NO_NAMESPACE;
            LOGGER.info((Object)"No default namespace found.");
        }
        if ((dcNS = ParserUtils.getNamespace(channel, "dc")) == null) {
            LOGGER.debug((Object)"No namespace for dublin core found");
            dcNS = defNS;
        }
        LOGGER.debug((Object)"start parsing.");
        String formatVersion = "0.3";
        if (channel.getAttribute("version") != null) {
            formatVersion = channel.getAttribute("version").getValue().trim();
            LOGGER.debug((Object)("Atom version " + formatVersion + " specified in document."));
        } else {
            LOGGER.info((Object)"No format version specified, using default.");
        }
        ParserUtils.matchCaseOfChildren(channel, new String[]{"title", "description", "tagline", "ttl", "modified", "author", "generator", "copyright", "link", "entry"});
        ChannelIF chnl = cBuilder.createChannel(channel, channel.getChildTextTrim("title", defNS));
        chnl.setFormat(ChannelFormat.ATOM_0_3);
        String language = channel.getAttributeValue("lang", Namespace.XML_NAMESPACE);
        if (language != null) {
            chnl.setLanguage(language);
        }
        if (channel.getChild("description") != null) {
            chnl.setDescription(channel.getChildTextTrim("description", defNS));
        } else {
            chnl.setDescription(channel.getChildTextTrim("tagline", defNS));
        }
        Element ttl = channel.getChild("ttl", dcNS);
        if (ttl != null && (ttlString = ttl.getTextTrim()) != null) {
            chnl.setTtl(Integer.parseInt(ttlString));
        }
        if ((modified = channel.getChild("modified", defNS)) != null) {
            chnl.setPubDate(ParserUtils.getDate(modified.getTextTrim()));
        }
        if ((author = channel.getChild("author", defNS)) != null) {
            ParserUtils.matchCaseOfChildren(author, "name");
            chnl.setCreator(author.getChildTextTrim("name", defNS));
        }
        if ((generator = channel.getChild("generator", defNS)) != null) {
            chnl.setGenerator(generator.getTextTrim());
        }
        if ((copyright = channel.getChild("copyright", defNS)) != null) {
            chnl.setCopyright(Atom_0_3_Parser.getCopyright(copyright));
        }
        List links = channel.getChildren("link", defNS);
        for (Element linkElement : links) {
            String rel = linkElement.getAttributeValue("rel");
            String href = linkElement.getAttributeValue("href");
            if (rel == null || href == null || !rel.equals("alternate")) continue;
            URL linkURL = ParserUtils.getURL(href);
            chnl.setSite(linkURL);
            break;
        }
        List items = channel.getChildren("entry", defNS);
        for (Element item : items) {
            Element elSubject;
            ParserUtils.matchCaseOfChildren(item, new String[]{"title", "link", "content", "summary", "issued", "subject"});
            Element elTitle = item.getChild("title", defNS);
            String strTitle = "<No Title>";
            if (elTitle != null) {
                strTitle = Atom_0_3_Parser.getTitle(elTitle);
                LOGGER.debug((Object)("Parsing title " + elTitle.getTextTrim() + "->" + strTitle));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Entry element found (" + strTitle + ")."));
            }
            String strLink = AtomParserUtils.getItemLink(item, defNS);
            String strDesc = Atom_0_3_Parser.getDescription(item, defNS);
            ItemIF curItem = cBuilder.createItem(item, chnl, strTitle, strDesc, ParserUtils.getURL(strLink));
            curItem.setFound(dateParsed);
            Element elIssued = item.getChild("issued", defNS);
            if (elIssued == null) {
                Element elCreated = item.getChild("created", defNS);
                if (elCreated != null) {
                    curItem.setDate(ParserUtils.getDate(elCreated.getTextTrim()));
                }
            } else {
                curItem.setDate(ParserUtils.getDate(elIssued.getTextTrim()));
            }
            if ((elSubject = item.getChild("subject", dcNS)) == null) continue;
            curItem.setSubject(elSubject.getTextTrim());
        }
        chnl.setLastUpdated(dateParsed);
        return chnl;
    }

    private static class Atom_0_3_ParserHolder {
        private static Atom_0_3_Parser instance = new Atom_0_3_Parser();

        private Atom_0_3_ParserHolder() {
        }
    }
}

