/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.hibernate;

import de.nava.informa.core.ImageIF;
import java.net.MalformedURLException;
import java.net.URL;

public class Image
implements ImageIF {
    private static final long serialVersionUID = 8134982328827904229L;
    private long id = -1L;
    private String title;
    private String description;
    private URL location;
    private URL link;
    private int width;
    private int height;

    public Image() {
        this("Unnamed image", null, null);
    }

    public Image(String title, URL location, URL link) {
        this.title = title;
        this.location = location;
        this.link = link;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocationString() {
        return this.location == null ? null : this.location.toString();
    }

    public void setLocationString(String loc) {
        if (loc == null || loc.trim().length() == 0) {
            this.location = null;
            return;
        }
        try {
            this.location = new URL(loc);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageIF)) {
            return false;
        }
        ImageIF image = (ImageIF)o;
        return !(this.location != null ? !this.location.equals(image.getLocation()) : image.getLocation() != null);
    }

    public int hashCode() {
        return this.location != null ? this.location.hashCode() : 0;
    }

    public String getLinkString() {
        return this.link == null ? null : this.link.toString();
    }

    public void setLinkString(String loc) {
        if (loc == null || loc.trim().length() == 0) {
            this.link = null;
            return;
        }
        try {
            this.link = new URL(loc);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public URL getLink() {
        return this.link;
    }

    public void setLink(URL link) {
        this.link = link;
    }
}

