/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.hibernate;

import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelGroup
implements ChannelGroupIF {
    private static final long serialVersionUID = -4572648595088013842L;
    private long id = -1L;
    private String title;
    private ChannelGroupIF parent;
    private Set<ChannelIF> channels;
    private Collection<ChannelGroupIF> children;

    public ChannelGroup() {
        this("Unnamed channel group");
    }

    public ChannelGroup(String title) {
        this(null, title);
    }

    public ChannelGroup(ChannelGroupIF parent, String title) {
        this.title = title;
        this.channels = Collections.synchronizedSet(new HashSet());
        this.parent = parent;
        this.children = new ArrayList<ChannelGroupIF>();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    public Set<ChannelIF> getChannels() {
        return this.channels;
    }

    public void setChannels(Set<ChannelIF> aChannels) {
        this.channels = Collections.synchronizedSet(aChannels);
    }

    @Override
    public void add(ChannelIF channel) {
        this.channels.add(channel);
    }

    @Override
    public void remove(ChannelIF channel) {
        this.channels.remove(channel);
    }

    @Override
    public Collection<ChannelIF> getAll() {
        return this.getChannels();
    }

    @Override
    public ChannelIF getById(long channelId) {
        for (ChannelIF channel : this.getChannels()) {
            if (channel.getId() != channelId) continue;
            return channel;
        }
        return null;
    }

    @Override
    public ChannelGroupIF getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ChannelGroupIF group) {
        this.parent = group;
    }

    public Collection<ChannelGroupIF> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<ChannelGroupIF> aChildren) {
        this.children = aChildren;
    }

    @Override
    public void addChild(ChannelGroupIF child) {
        this.getChildren().add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(ChannelGroupIF child) {
        this.getChildren().remove(child);
    }

    public String toString() {
        return "[Hibernate ChannelGroup \"" + this.getTitle() + "\"(id=" + this.id + ")]";
    }
}

