/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.hibernate;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelBuilderException;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.hibernate.Category;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelGroup;
import de.nava.informa.impl.hibernate.Cloud;
import de.nava.informa.impl.hibernate.Image;
import de.nava.informa.impl.hibernate.Item;
import de.nava.informa.impl.hibernate.ItemEnclosure;
import de.nava.informa.impl.hibernate.ItemGuid;
import de.nava.informa.impl.hibernate.ItemSource;
import de.nava.informa.impl.hibernate.SessionHandler;
import de.nava.informa.impl.hibernate.TextInput;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdom.Element;

public class ChannelBuilder
implements ChannelBuilderIF {
    private static Log logger = LogFactory.getLog(ChannelBuilder.class);
    private Session session;
    private SessionHandler handler;
    private Transaction transaction;

    public ChannelBuilder(Session session) {
        logger.info((Object)("New Channel Builder for: " + session));
        this.session = session;
        this.handler = null;
    }

    public ChannelBuilder(SessionHandler handler) {
        logger.debug((Object)("New Channel Builder for: " + handler));
        this.handler = handler;
        this.session = null;
    }

    public void beginTransaction() throws ChannelBuilderException {
        logger.info((Object)"beginTransaction");
        if (this.session != null || this.handler == null) {
            throw new IllegalStateException("Session != null || handler == null");
        }
        try {
            this.session = this.handler.getSession();
            this.transaction = this.session.beginTransaction();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            this.transaction = null;
            throw new ChannelBuilderException(e);
        }
    }

    public void endTransaction() throws ChannelBuilderException {
        logger.info((Object)"endTransaction");
        if (this.handler == null || this.transaction == null || this.session == null) {
            throw new IllegalStateException("handler == null || transaction == null || session == null");
        }
        try {
            this.transaction.commit();
            this.session.flush();
            this.session.close();
            this.session = null;
            this.transaction = null;
        }
        catch (HibernateException he) {
            if (this.transaction != null) {
                try {
                    he.printStackTrace();
                    this.transaction.rollback();
                    this.transaction = null;
                    if (this.session.isOpen()) {
                        this.session.close();
                        this.session = null;
                    }
                }
                catch (HibernateException e) {
                    if (this.session.isOpen()) {
                        this.session = null;
                    }
                    e.printStackTrace();
                    throw new ChannelBuilderException(e);
                }
            }
            throw new ChannelBuilderException(he);
        }
    }

    public boolean inTransaction() {
        return this.session != null && this.transaction != null;
    }

    public void resetTransaction() {
        logger.debug((Object)"Transaction being reset.");
        if (this.transaction != null) {
            try {
                this.transaction.commit();
                this.transaction = null;
            }
            catch (HibernateException e) {
                this.transaction = null;
                e.printStackTrace();
            }
        }
        if (this.session != null) {
            try {
                this.session.flush();
                this.session.close();
                this.session = null;
            }
            catch (HibernateException e) {
                e.printStackTrace();
                this.session = null;
            }
        }
    }

    public Session getSession() {
        if (this.handler == null || this.session == null) {
            throw new IllegalStateException("getSession must be bracketed by begin/endTransaction");
        }
        if (!this.handler.isSessionOpen()) {
            throw new IllegalStateException("Hibernate Handler must be open");
        }
        return this.session;
    }

    public void update(Object o) throws ChannelBuilderException {
        try {
            this.session.update(o);
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new ChannelBuilderException("update() Failed");
        }
    }

    public void delete(Object o) throws ChannelBuilderException {
        try {
            this.session.delete(o);
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new ChannelBuilderException("delete() Failed");
        }
    }

    public void init(Properties props) throws ChannelBuilderException {
        logger.debug((Object)"initialising channel builder for hibernate backend");
    }

    public ChannelGroupIF createChannelGroup(String title) {
        ChannelGroup obj = new ChannelGroup(title);
        this.save(obj);
        return obj;
    }

    public ChannelIF createChannel(String title) {
        return this.createChannel((Element)null, title);
    }

    public ChannelIF createChannel(Element channelElement, String title) {
        return this.createChannel(channelElement, title, null);
    }

    public ChannelIF createChannel(String title, String location) {
        return this.createChannel(null, title, location);
    }

    public ChannelIF createChannel(Element channelElement, String title, String location) {
        ChannelIF obj = null;
        if (location != null) {
            Query query = this.session.createQuery("from Channel as channel where channel.locationString = ? ");
            query.setString(0, location);
            obj = (ChannelIF)query.uniqueResult();
        }
        if (obj == null) {
            obj = new Channel(channelElement, title, location);
            this.session.save((Object)obj);
        } else {
            logger.info((Object)("Found already existing channel instance with location " + location));
        }
        return obj;
    }

    public ItemIF createItem(ChannelIF channel, String title, String description, URL link) {
        return this.createItem(null, channel, title, description, link);
    }

    public ItemIF createItem(Element itemElement, ChannelIF channel, String title, String description, URL link) {
        if (link == null) {
            throw new RuntimeException("link required for item " + title + " for persistence uniqueness");
        }
        Query query = this.session.createQuery("from Item as item where item.linkString = ? ");
        query.setString(0, link.toString());
        ItemIF obj = (ItemIF)query.uniqueResult();
        if (obj == null) {
            obj = new Item(channel, title, description, link);
            if (channel != null) {
                channel.addItem(obj);
            }
            this.session.save((Object)obj);
        } else {
            logger.info((Object)("Found already existing item instance with location " + link));
        }
        return obj;
    }

    public ItemIF createItem(ChannelIF channel, ItemIF item) {
        throw new RuntimeException("Not implemented yet.");
    }

    public ImageIF createImage(String title, URL location, URL link) {
        Query query = this.session.createQuery("from Image as img where img.locationString = ? ");
        query.setString(0, location.toString());
        Image obj = (Image)query.uniqueResult();
        if (obj == null) {
            obj = new Image(title, location, link);
            this.session.save((Object)obj);
        }
        return obj;
    }

    public CloudIF createCloud(String domain, int port, String path, String registerProcedure, String protocol) {
        logger.info((Object)"ChannelBuilder is creating a Persistent Cloud");
        Query query = this.session.createQuery("from Cloud as cld where cld.domain = ? and cld.port = ? and cld.path = ?");
        query.setString(0, domain);
        query.setInteger(1, port);
        query.setString(2, path);
        CloudIF obj = (CloudIF)query.uniqueResult();
        if (obj == null) {
            obj = new Cloud(domain, port, path, registerProcedure, protocol);
            this.session.save((Object)obj);
        }
        return obj;
    }

    public TextInputIF createTextInput(String title, String description, String name, URL link) {
        Query query = this.session.createQuery("from TextInput as txt where txt.title = ? and txt.name = ? and txt.linkString = ? ");
        query.setString(0, title);
        query.setString(1, name);
        query.setString(2, link.toString());
        TextInput obj = (TextInput)query.uniqueResult();
        if (obj == null) {
            obj = new TextInput(title, description, name, link);
            this.session.save((Object)obj);
        }
        return obj;
    }

    public ItemSourceIF createItemSource(ItemIF item, String name, String location, Date timestamp) {
        return null;
    }

    public ItemSourceIF createItemSource(String name, String location, Date timestamp) {
        Query query = this.session.createQuery("from ItemSource as src where src.name = ? and src.location = ? and src.timestamp = ?  ");
        query.setString(0, name);
        query.setString(1, location);
        query.setTimestamp(2, timestamp);
        ItemSourceIF obj = (ItemSourceIF)query.uniqueResult();
        if (obj == null) {
            obj = new ItemSource(null, name, location, timestamp);
            this.session.save((Object)obj);
        }
        return obj;
    }

    public ItemEnclosureIF createItemEnclosure(ItemIF item, URL location, String type, int length) {
        Query query = this.session.createQuery("from ItemEnclosure as enc where enc.item.id = ? ");
        query.setLong(0, item.getId());
        ItemEnclosureIF obj = (ItemEnclosureIF)query.uniqueResult();
        if (obj == null) {
            obj = new ItemEnclosure(item, location, type, length);
            this.session.save((Object)obj);
        }
        return obj;
    }

    public ItemGuidIF createItemGuid(ItemIF item, String location, boolean permaLink) {
        Query query = this.session.createQuery("from ItemGuid as guid where guid.location = ? ");
        query.setString(0, location);
        ItemGuidIF guid = (ItemGuidIF)query.uniqueResult();
        if (guid == null) {
            guid = new ItemGuid(item, location, permaLink);
            guid.setPermaLink(permaLink);
            this.session.save((Object)guid);
        }
        return guid;
    }

    public CategoryIF createCategory(CategoryIF parent, String title) {
        return this.createCategory(parent, title, null);
    }

    public CategoryIF createCategory(CategoryIF parent, String title, String domain) {
        Query query = this.session.createQuery("from Category as cat where cat.title = ? and cat.domain = ? ");
        query.setString(0, title);
        query.setString(1, domain);
        CategoryIF cat = (CategoryIF)query.uniqueResult();
        if (cat == null) {
            cat = new Category(title);
            cat.setDomain(domain);
            if (parent != null) {
                parent.addChild(cat);
            }
            this.session.save((Object)cat);
        }
        return cat;
    }

    public void close() throws ChannelBuilderException {
        logger.debug((Object)"closing channel builder for hibernate backend");
    }

    public ChannelGroup reload(ChannelGroup group) throws ChannelBuilderException {
        try {
            this.getSession().load((Object)group, (Serializable)new Long(group.getId()));
        }
        catch (HibernateException e) {
            throw new ChannelBuilderException("Unable to reload group: " + e.getMessage());
        }
        return group;
    }

    public Channel reload(Channel channel) throws ChannelBuilderException {
        try {
            this.getSession().load((Object)channel, (Serializable)new Long(channel.getId()));
        }
        catch (HibernateException e) {
            throw new ChannelBuilderException("Unable to reload channel: " + e.getMessage());
        }
        return channel;
    }

    public Item reload(Item item) throws ChannelBuilderException {
        try {
            this.getSession().load((Object)item, (Serializable)new Long(item.getId()));
        }
        catch (HibernateException e) {
            throw new ChannelBuilderException("Unable to reload item: " + e.getMessage());
        }
        return item;
    }

    protected void save(Object dataObject) {
        if (this.session == null) {
            throw new IllegalStateException("Session == null");
        }
        try {
            this.session.save(dataObject);
        }
        catch (HibernateException he) {
            throw new RuntimeException(he.getMessage());
        }
    }
}

