/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.hibernate;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelObserverIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.hibernate.ChannelGroup;
import de.nava.informa.utils.XmlPathUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
implements ChannelIF {
    private static Log logger = LogFactory.getLog(Channel.class);
    private static final long serialVersionUID = 7579933431503905957L;
    private long id = -1L;
    private String title;
    private String description;
    private URL location;
    private URL site;
    private String creator;
    private String publisher;
    private String language;
    private ChannelFormat format;
    private Set<ItemIF> items;
    private Set<ChannelGroup> groups;
    private CloudIF cloud;
    private ImageIF image;
    private TextInputIF textInput;
    private String copyright;
    private Collection<CategoryIF> categories;
    private Date lastUpdated;
    private Date lastBuild;
    private Date pubDate;
    private String rating;
    private String generator;
    private String docs;
    private int ttl = -1;
    private Element channelElement;
    private ChannelUpdatePeriod updatePeriod = ChannelUpdatePeriod.UPDATE_DAILY;
    private int updateFrequency = 1;
    private Date updateBase;
    private transient Collection<ChannelObserverIF> observers;

    public Channel() {
        this(null, null, null);
    }

    public Channel(String title) {
        this(null, title, null);
    }

    public Channel(String title, String location) {
        this(null, title, location);
    }

    public Channel(String title, URL location) {
        this(null, title, location.toExternalForm());
    }

    public Channel(Element channelElement) {
        this(channelElement, "Unnamed channel");
    }

    public Channel(Element channelElement, String title) {
        this(channelElement, title, null);
    }

    public Channel(Element channelElement, String title, String location) {
        this.channelElement = channelElement;
        this.title = title;
        this.setLocationString(location);
        this.items = new HashSet<ItemIF>();
        this.categories = new ArrayList<CategoryIF>();
        this.observers = new ArrayList<ChannelObserverIF>();
        this.groups = new HashSet<ChannelGroup>();
        this.format = ChannelFormat.UNKNOWN_CHANNEL_FORMAT;
        this.lastUpdated = new Date();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public String getLocationString() {
        return this.location == null ? null : this.location.toString();
    }

    public void setLocationString(String loc) {
        if (loc == null || loc.trim().length() == 0) {
            this.location = null;
            return;
        }
        try {
            this.location = new URL(loc);
        }
        catch (MalformedURLException e) {
            logger.warn((Object)"Tried to set location to invalid URL", (Throwable)e);
            this.location = null;
        }
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URL location) {
        this.location = location;
    }

    public String getSiteString() {
        return this.site == null ? null : this.site.toString();
    }

    public void setSiteString(String siteUrl) {
        if (siteUrl == null || siteUrl.trim().length() == 0) {
            this.site = null;
            return;
        }
        try {
            this.site = new URL(siteUrl);
        }
        catch (MalformedURLException e) {
            logger.warn((Object)"Tried to set site to invalid URL", (Throwable)e);
            this.site = null;
        }
    }

    @Override
    public URL getSite() {
        return this.site;
    }

    @Override
    public void setSite(URL site) {
        this.site = site;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(String aCreator) {
        this.creator = aCreator;
    }

    @Override
    public String getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(String aPublisher) {
        this.publisher = aPublisher;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String aLanguage) {
        this.language = aLanguage;
    }

    public String getFormatString() {
        return this.format.toString();
    }

    public void setFormatString(String strFormat) {
        if (strFormat.equals(ChannelFormat.RSS_0_90.toString())) {
            this.format = ChannelFormat.RSS_0_90;
        } else if (strFormat.equals(ChannelFormat.RSS_0_91.toString())) {
            this.format = ChannelFormat.RSS_0_91;
        } else if (strFormat.equals(ChannelFormat.RSS_0_92.toString())) {
            this.format = ChannelFormat.RSS_0_92;
        } else if (strFormat.equals(ChannelFormat.RSS_0_93.toString())) {
            this.format = ChannelFormat.RSS_0_93;
        } else if (strFormat.equals(ChannelFormat.RSS_0_94.toString())) {
            this.format = ChannelFormat.RSS_0_94;
        } else if (strFormat.equals(ChannelFormat.RSS_1_0.toString())) {
            this.format = ChannelFormat.RSS_1_0;
        } else if (strFormat.equals(ChannelFormat.RSS_2_0.toString())) {
            this.format = ChannelFormat.RSS_2_0;
        }
    }

    @Override
    public ChannelFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(ChannelFormat aFormat) {
        this.format = aFormat;
    }

    public Set<ChannelGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<ChannelGroup> aGroups) {
        this.groups = aGroups;
    }

    @Override
    public Set<ItemIF> getItems() {
        return this.items;
    }

    public void setItems(Set<ItemIF> anItems) {
        this.items = anItems;
    }

    @Override
    public void addItem(ItemIF item) {
        this.items.add(item);
        item.setChannel(this);
        this.notifyObserversItemAdded(item);
    }

    @Override
    public void removeItem(ItemIF item) {
        this.items.remove(item);
    }

    @Override
    public ItemIF getItem(long itemId) {
        ItemIF theItem = null;
        for (ItemIF curItem : this.items) {
            if (curItem.getId() != itemId) continue;
            theItem = curItem;
            break;
        }
        return theItem;
    }

    @Override
    public ImageIF getImage() {
        return this.image;
    }

    @Override
    public void setImage(ImageIF anImage) {
        this.image = anImage;
    }

    @Override
    public TextInputIF getTextInput() {
        return this.textInput;
    }

    @Override
    public void setTextInput(TextInputIF aTextInput) {
        this.textInput = aTextInput;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public void setCopyright(String aCopyright) {
        this.copyright = aCopyright;
    }

    @Override
    public String getRating() {
        return this.rating;
    }

    @Override
    public void setRating(String aRating) {
        this.rating = aRating;
    }

    @Override
    public CloudIF getCloud() {
        return this.cloud;
    }

    @Override
    public void setCloud(CloudIF aCloud) {
        this.cloud = aCloud;
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void setGenerator(String aGenerator) {
        this.generator = aGenerator;
    }

    @Override
    public String getDocs() {
        return this.docs;
    }

    @Override
    public void setDocs(String aDocs) {
        this.docs = aDocs;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public void setTtl(int aTtl) {
        this.ttl = aTtl;
    }

    @Override
    public Collection getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(Collection<CategoryIF> aCategories) {
        this.categories = aCategories;
    }

    @Override
    public void addCategory(CategoryIF category) {
        this.categories.add(category);
    }

    @Override
    public void removeCategory(CategoryIF category) {
        this.categories.remove(category);
    }

    @Override
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public void setLastUpdated(Date date) {
        this.lastUpdated = date;
        this.notifyObserversChannelUpdated();
    }

    @Override
    public Date getLastBuildDate() {
        return this.lastBuild;
    }

    @Override
    public void setLastBuildDate(Date date) {
        this.lastBuild = date;
    }

    @Override
    public Date getPubDate() {
        return this.pubDate;
    }

    @Override
    public void setPubDate(Date date) {
        this.pubDate = date;
    }

    @Override
    public ChannelUpdatePeriod getUpdatePeriod() {
        return this.updatePeriod;
    }

    @Override
    public void setUpdatePeriod(ChannelUpdatePeriod anUpdatePeriod) {
        this.updatePeriod = anUpdatePeriod;
    }

    @Override
    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    @Override
    public void setUpdateFrequency(int anUpdateFrequency) {
        this.updateFrequency = anUpdateFrequency;
    }

    @Override
    public Date getUpdateBase() {
        return this.updateBase;
    }

    @Override
    public void setUpdateBase(Date date) {
        this.updateBase = date;
    }

    @Override
    public String getElementValue(String path) {
        return XmlPathUtils.getElementValue(this.channelElement, path);
    }

    @Override
    public String[] getElementValues(String path, String[] elements) {
        return XmlPathUtils.getElementValues(this.channelElement, path, elements);
    }

    @Override
    public String getAttributeValue(String path, String attribute) {
        return XmlPathUtils.getAttributeValue(this.channelElement, path, attribute);
    }

    @Override
    public String[] getAttributeValues(String path, String[] attributes) {
        return XmlPathUtils.getAttributeValues(this.channelElement, path, attributes);
    }

    @Override
    public void addObserver(ChannelObserverIF o) {
        this.observers.add(o);
    }

    @Override
    public void removeObserver(ChannelObserverIF o) {
        this.observers.remove(o);
    }

    public String toString() {
        return "[Hibernate Channel (" + this.id + "): " + this.title + "(" + this.getItems().size() + ")( " + this.location + " )]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelIF)) {
            return false;
        }
        ChannelIF channel = (ChannelIF)o;
        String channelTitle = channel.getTitle();
        if (this.title != null ? !this.title.equals(channelTitle) : channelTitle != null) {
            return false;
        }
        URL channelLocation = channel.getLocation();
        if (this.location != null ? channelLocation == null || !this.location.toString().equalsIgnoreCase(channelLocation.toString()) : channelLocation != null) {
            return false;
        }
        String channelDescription = channel.getDescription();
        return !(this.description != null ? !this.description.equals(channelDescription) : channelDescription != null);
    }

    public int hashCode() {
        return this.location.toString().hashCode();
    }

    public void notifyObserversItemAdded(ItemIF newItem) {
        for (ChannelObserverIF o : this.observers) {
            o.itemAdded(newItem);
        }
    }

    public void notifyObserversChannelUpdated() {
        for (ChannelObserverIF o : this.observers) {
            o.channelRetrieved(this);
        }
    }
}

