/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.impl.basic.IdGenerator;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
implements CategoryIF {
    private static final long serialVersionUID = 8319888961720961902L;
    private long id = IdGenerator.getInstance().getId();
    private String title;
    private String domain;
    private CategoryIF parent;
    private Collection<CategoryIF> children;

    public Category() {
        this("[Unnamed Category]");
    }

    public Category(String title) {
        this(null, title);
    }

    public Category(CategoryIF parent, String title) {
        this.title = title;
        this.parent = parent;
        this.children = new ArrayList<CategoryIF>();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public CategoryIF getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CategoryIF parent) {
        this.parent = parent;
    }

    @Override
    public Collection<CategoryIF> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(CategoryIF child) {
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(CategoryIF child) {
        this.children.remove(child);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CategoryIF)) {
            return false;
        }
        CategoryIF cmp = (CategoryIF)obj;
        return cmp.getTitle().equals(this.title) && cmp.getId() == this.id;
    }

    public int hashCode() {
        return this.title.hashCode() + new Long(this.id).hashCode();
    }

    public String toString() {
        return "[Category (" + this.id + "): " + this.title + "]";
    }
}

