/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.exporters;

import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ParserUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RSS_1_0_Exporter
implements ChannelExporterIF {
    private static final String NS_DEFAULT = "http://purl.org/rss/1.0/";
    private static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String NS_DC = "http://purl.org/dc/elements/1.1/";
    private static final String NS_SY = "http://purl.org/rss/1.0/modules/syndication/";
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private Writer writer;
    private String encoding;

    public RSS_1_0_Exporter(String filename) throws IOException {
        this(new File(filename), "utf-8");
    }

    public RSS_1_0_Exporter(File file) throws IOException {
        this(file, "utf-8");
    }

    public RSS_1_0_Exporter(File file, String encoding) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        this.encoding = encoding;
    }

    public RSS_1_0_Exporter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public void write(ChannelIF channel) throws IOException {
        Element itemElem;
        if (this.writer == null) {
            throw new RuntimeException("No writer has been initialized.");
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding(this.encoding);
        XMLOutputter outputter = new XMLOutputter(format);
        Namespace defNs = Namespace.getNamespace((String)NS_DEFAULT);
        Namespace rdfNs = Namespace.getNamespace((String)"rdf", (String)NS_RDF);
        Namespace dcNs = Namespace.getNamespace((String)"dc", (String)NS_DC);
        Namespace syNs = Namespace.getNamespace((String)"sy", (String)NS_SY);
        Element rootElem = new Element("RDF", rdfNs);
        rootElem.addNamespaceDeclaration(defNs);
        rootElem.addNamespaceDeclaration(dcNs);
        rootElem.addNamespaceDeclaration(syNs);
        Element channelElem = new Element("channel", defNs);
        if (channel.getLocation() != null) {
            channelElem.setAttribute("about", channel.getLocation().toString(), rdfNs);
        }
        channelElem.addContent((Content)new Element("title", defNs).setText(channel.getTitle()));
        if (channel.getSite() != null) {
            channelElem.addContent((Content)new Element("link", defNs).setText(channel.getSite().toString()));
            channelElem.addContent((Content)new Element("source", dcNs).setAttribute("resource", channel.getSite().toString()));
        }
        channelElem.addContent((Content)new Element("description", defNs).setText(channel.getDescription()));
        if (channel.getLanguage() != null) {
            channelElem.addContent((Content)new Element("language", dcNs).setText(channel.getLanguage()));
        }
        if (channel.getCopyright() != null) {
            channelElem.addContent((Content)new Element("copyright", dcNs).setText(channel.getCopyright()));
        }
        if (channel.getUpdateBase() != null) {
            channelElem.addContent((Content)new Element("updateBase", syNs).setText(df.format(channel.getUpdateBase())));
        }
        if (channel.getUpdatePeriod() != null) {
            channelElem.addContent((Content)new Element("updateFrequency", syNs).setText(new Integer(channel.getUpdateFrequency()).toString()));
            channelElem.addContent((Content)new Element("updatePeriod", syNs).setText(channel.getUpdatePeriod().toString()));
        }
        if (channel.getImage() != null) {
            Element imgElem = new Element("image", defNs);
            imgElem.addContent((Content)new Element("title", defNs).setText(channel.getImage().getTitle()));
            imgElem.addContent((Content)new Element("url", defNs).setText(channel.getImage().getLocation().toString()));
            imgElem.addContent((Content)new Element("link", defNs).setText(channel.getImage().getLink().toString()));
            imgElem.addContent((Content)new Element("height", defNs).setText("" + channel.getImage().getHeight()));
            imgElem.addContent((Content)new Element("width", defNs).setText("" + channel.getImage().getWidth()));
            imgElem.addContent((Content)new Element("description", defNs).setText(channel.getImage().getDescription()));
            channelElem.addContent((Content)imgElem);
        }
        Element itemsElem = new Element("items", defNs);
        Element seqElem = new Element("Seq", rdfNs);
        Set<ItemIF> items = channel.getItems();
        for (ItemIF item : items) {
            itemElem = new Element("li", rdfNs);
            if (item.getLink() != null) {
                itemElem.setAttribute("resource", item.getLink().toString());
            }
            seqElem.addContent((Content)itemElem);
        }
        itemsElem.addContent((Content)seqElem);
        channelElem.addContent((Content)itemsElem);
        rootElem.addContent((Content)channelElem);
        items = channel.getItems();
        for (ItemIF item : items) {
            itemElem = new Element("item", defNs);
            if (item.getLink() != null) {
                itemElem.setAttribute("about", item.getLink().toString(), rdfNs);
            }
            itemElem.addContent((Content)new Element("title", defNs).setText(item.getTitle()));
            if (item.getLink() != null) {
                itemElem.addContent((Content)new Element("link", defNs).setText(item.getLink().toString()));
            }
            if (item.getDescription() != null) {
                itemElem.addContent((Content)new Element("description", dcNs).setText(item.getDescription()));
            }
            if (item.getDate() != null) {
                itemElem.addContent((Content)new Element("date", dcNs).setText(ParserUtils.formatDate(item.getDate())));
            }
            rootElem.addContent((Content)itemElem);
        }
        Document doc = new Document(rootElem);
        outputter.output(doc, this.writer);
        this.writer.close();
    }
}

