/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.W;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableToChartAdapter
implements AnnotatedChartModel {
    private TableModel a;
    private String b;
    private List<Annotation> c = new ArrayList<Annotation>();
    private final List<ChartModelListener> d = Collections.synchronizedList(new ArrayList());
    private Map<Integer, Highlight> e = new HashMap<Integer, Highlight>();

    public TableToChartAdapter(String string, TableModel tableModel) {
        this.a = tableModel;
        this.b = string;
    }

    public void addHighlight(int n, Highlight highlight) {
        this.e.put(n, highlight);
    }

    public void removeHighlight(int n) {
        this.e.remove(n);
    }

    @Override
    public String getName() {
        return this.b;
    }

    @Override
    public Chartable getPoint(int n) {
        Double d2 = (Double)this.a.getValueAt(n, 0);
        Double d3 = (Double)this.a.getValueAt(n, 1);
        ChartPoint chartPoint = new ChartPoint((double)d2, (double)d3);
        Highlight highlight = this.e.get(n);
        if (highlight != null) {
            chartPoint.setHighlight(highlight);
        }
        return chartPoint;
    }

    @Override
    public int getPointCount() {
        return this.a.getRowCount();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    @Override
    public int getAnnotationCount() {
        return 0;
    }

    public void clearAnnotations() {
        this.c.clear();
    }

    @Override
    public Annotation getAnnotation(int n) {
        return this.c.get(n);
    }

    public void addAnnotation(Annotation annotation) {
        this.c.add(annotation);
    }

    public void removeAnnotation(Annotation annotation) {
        this.c.remove(annotation);
    }

    @Override
    public boolean isAnnotationsVisible() {
        return true;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        boolean bl = this.d.contains(chartModelListener);
        if (ChartPoint.e == 0 && !bl) {
            bl = this.d.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.d.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public void update() {
        this.fireModelChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChanged() {
        int n = ChartPoint.e;
        List<ChartModelListener> list = this.d;
        synchronized (list) {
            for (ChartModelListener chartModelListener : this.d) {
                chartModelListener.chartModelChanged();
                if (n == 0) {
                    if (n == 0) continue;
                }
                break;
            }
            return;
        }
    }

    static {
        if (!W.a(4096)) {
            Lm.showInvalidProductMessage(TableToChartAdapter.class.getName(), 4096);
        }
    }
}

