/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;

public class UninstallPreviousAction
extends SystemInstallAction {
    public static final String PROP_UPGRADE_UNINSTALL = "install4j.upgradeUninstall";
    private File installationDirectory;
    private boolean onlyIfSameApplicationId = true;

    public File getInstallationDirectory() {
        return UninstallPreviousAction.replaceVariables(this.installationDirectory);
    }

    public void setInstallationDirectory(File file) {
        this.installationDirectory = file;
    }

    public boolean isOnlyIfSameApplicationId() {
        return this.onlyIfSameApplicationId;
    }

    public void setOnlyIfSameApplicationId(boolean bl) {
        this.onlyIfSameApplicationId = bl;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        try {
            ProgressInterface progressInterface = installerContext.getProgressInterface();
            Logger.getInstance().info(this, "checking running processes");
            if (!RunningProcessChecker.checkDefaultRunningLauncher("AppRunningError")) {
                throw new UserCanceledException();
            }
            Logger.getInstance().info(this, "checking running processes ok");
            File file = this.getInstallationDirectory();
            File file2 = file == null || file.getPath().trim().length() == 0 ? installerContext.getInstallationDirectory() : file;
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            Logger.getInstance().info(this, "getting previous installation id");
            String string = InstallerUtil.getOldApplicationId(file2);
            if (string != null && (!this.onlyIfSameApplicationId || installerConfig.getApplicationId().equals(string))) {
                progressInterface.setStatusMessage(Messages.getMessages().getString("StatusUninstallingPrevious"));
                progressInterface.setIndeterminateProgress(true);
                UninstallerThread uninstallerThread = new UninstallerThread(file2, installerContext.getInstallationDirectory().getCanonicalFile().equals(file2.getCanonicalFile()));
                Logger.getInstance().info(this, "starting uninstaller");
                uninstallerThread.start();
                while (uninstallerThread.isAlive()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!installerContext.isCancelling()) continue;
                    uninstallerThread.interrupt();
                }
                progressInterface.setIndeterminateProgress(false);
            } else {
                Logger.getInstance().info(this, "no previous installation detected, uninstaller was not started");
            }
            Logger.getInstance().info(this, "finished");
            return true;
        }
        catch (UserCanceledException userCanceledException) {
            Logger.getInstance().info(this, "user cancelled");
            throw userCanceledException;
        }
        catch (Throwable throwable) {
            Logger.getInstance().log(throwable);
            return false;
        }
    }

    private class UninstallerThread
    extends Thread {
        private File installationDirectory;
        private boolean upgrade;

        public UninstallerThread(File file, boolean bl) {
            super("uninstaller waiting thread");
            this.installationDirectory = file;
            this.upgrade = bl;
        }

        public void run() {
            try {
                File file = new File("uninstallPrevious.log");
                if (InstallerUtil.isMacOS()) {
                    this.runJavaUninstaller(null);
                } else if (InstallerUtil.isWindows()) {
                    InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
                    File file2 = new File("i4j_undel.log.tmp");
                    String[] stringArray = new String[]{"-q_i4j_internal", "-q", "-Dwindel.logfile=" + file2.getAbsolutePath(), "-Dinstall4j.alternativeLogfile=" + file.getAbsolutePath(), "-Dinstall4j.upgradeUninstall=" + this.upgrade};
                    LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(this.installationDirectory, installerConfig.getUninstallerPath() + ".exe")).arguments(stringArray).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
                    Integer n = LaunchHelper.launchApplication(launchDescriptor);
                    Logger.getInstance().info(this, "native uninstaller process returned " + n);
                    if (n == null || n == 83) {
                        this.runJavaUninstaller(file);
                    } else {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.deleteWindowsUndelFiles(file2);
                    }
                } else {
                    InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
                    Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", new File(this.installationDirectory, installerConfig.getUninstallerPath()).getAbsolutePath(), "-q", "-Dinstall4j.alternativeLogfile=" + file.getAbsolutePath(), "-Dinstall4j.upgradeUninstall=" + this.upgrade}, null, new File(this.installationDirectory, ".."));
                    try {
                        if (process.waitFor() == 83) {
                            this.runJavaUninstaller(file);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        process.destroy();
                    }
                }
                Logger.getInstance().info(this, "see uninstallPrevious.log for the log file of the uninstaller");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void runJavaUninstaller(File file) throws IOException {
            Serializable serializable;
            File file2 = new File(this.installationDirectory, ".install4j");
            String string = new File(file2, "i4jruntime.jar").getAbsolutePath() + File.pathSeparator + new File(file2, "user.jar").getAbsolutePath();
            File[] fileArray = new File(file2, "user").listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    serializable = fileArray[i];
                    if (!serializable.getName().endsWith(".jar") && !serializable.getName().endsWith(".zip")) continue;
                    string = string + File.pathSeparator + serializable.getAbsolutePath();
                }
            }
            String[] stringArray = new String[]{"-Dinstall4j.upgradeUninstall=" + this.upgrade, "-Dinstall4j.alternativeLogfile=" + (file == null ? "null" : file.getAbsolutePath()), "-cp", string, "com.install4j.runtime.installer.Uninstaller", "-q"};
            serializable = new LaunchDescriptor(new File(System.getProperty("java.home"), "bin/java")).arguments(stringArray).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
            Integer n = LaunchHelper.launchApplication((LaunchDescriptor)serializable);
            Logger.getInstance().info(this, "uninstaller process returned " + n);
        }

        private void deleteWindowsUndelFiles(File file) throws IOException {
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                if (bufferedReader.readLine() != null) {
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        if (!string.equals("") && !new File(string).delete()) {
                            System.out.println("could not delete " + string);
                        }
                        string = bufferedReader.readLine();
                    }
                }
                bufferedReader.close();
                file.delete();
            } else {
                System.out.println(file + " doesn't exist");
            }
        }
    }
}

