/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.FolderChooser;
import hermes.Hermes;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import hermes.swing.actions.BrowseActionListenerAdapter;
import hermes.swing.actions.DirectoryCache;
import hermes.util.JMSUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class SaveMessagesAsTextAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(SaveMessagesAsTextAction.class);

    public SaveMessagesAsTextAction() {
        this.putValue("Name", "Save individually as Text...");
        this.putValue("ShortDescription", "Save selected messages as Text in separate files.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.messages.save.text"));
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            BrowserAction action;
            if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction && (action = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument()).getSelectedMessages().size() > 0) {
                FolderChooser chooser = DirectoryCache.lastSaveAsDirectory == null ? new FolderChooser(new File(HermesBrowser.getBrowser().getRepositoryManager().getDirectory())) : new FolderChooser(DirectoryCache.lastSaveAsDirectory);
                if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Select directory for messages") == 0) {
                    DirectoryCache.lastSaveAsDirectory = chooser.getSelectedFile();
                    for (Message message : action.getSelectedMessages()) {
                        if (message instanceof TextMessage) {
                            String filename = JMSUtils.getFilenameFromMessageID(message.getJMSMessageID());
                            filename = DirectoryCache.lastSaveAsDirectory.getAbsolutePath() + File.separator + filename + ".txt";
                            TextMessage textMessage = (TextMessage)message;
                            File file = new File(filename);
                            FileWriter writer = new FileWriter(file);
                            writer.write(textMessage.getText());
                            writer.flush();
                            writer.close();
                            log.debug((Object)("written TextMessage payload to " + file.getAbsolutePath()));
                            continue;
                        }
                        throw new HermesException("Can only write TextMessages as text files, other messages must be written as XML");
                    }
                    if (action.getSelectedMessages().size() == 1) {
                        Hermes.ui.getDefaultMessageSink().add("Message saved");
                    } else {
                        Hermes.ui.getDefaultMessageSink().add(action.getSelectedMessages() + " messages saved");
                    }
                } else {
                    Hermes.ui.getDefaultMessageSink().add("Save messages cancelled");
                }
            }
        }
        catch (Exception e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to save: ", e);
        }
    }
}

