/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowseContextAction;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.ContextTreeNode;
import hermes.swing.actions.JNDIAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.naming.Context;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class RenameJNDIBindingAction
extends JNDIAction {
    public RenameJNDIBindingAction() {
        this.putValue("Name", "Rename...");
        this.putValue("ShortDescription", "Rename the binding.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.object.rename"));
        this.setEnabled(false);
    }

    protected boolean checkEnabled(TreePath path) {
        return path != null && path.getLastPathComponent() instanceof AbstractTreeNode;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            BrowseContextAction browseContext = (BrowseContextAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            AbstractTreeNode node = (AbstractTreeNode)browseContext.getContextTree().getSelectionPath().getLastPathComponent();
            String binding = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Enter Binding", "");
            if (binding != null && !binding.equals("") && node.getParent() instanceof ContextTreeNode) {
                ContextTreeNode contextNode = (ContextTreeNode)node.getParent();
                Context context = (Context)contextNode.getContextFactory().createContext().lookup(node.getPathFromRoot());
                context.rename(node.getId(), binding);
                context.close();
                Hermes.ui.getDefaultMessageSink().add(node.getId() + " renamed to " + binding);
            }
        }
        catch (Throwable ex) {
            HermesBrowser.getBrowser().showErrorDialog("Cannot create context:", ex);
        }
    }
}

