/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import hermes.browser.actions.MessageStoreBrowserAction;
import hermes.browser.tasks.AddToMessageStoreTask;
import hermes.swing.actions.BrowseActionListenerAdapter;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public class PasteMessagesFromClipboardAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(PasteMessagesFromClipboardAction.class);

    public PasteMessagesFromClipboardAction() {
        super(false, false, false);
        this.putValue("Name", "Paste");
        this.putValue("ShortDescription", "Paste any messages from the clipboard to this queue/topic.");
        this.putValue("SmallIcon", IconCache.getIcon("paste"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65487, 0, false));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent arg0) {
        block11: {
            if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction) {
                try {
                    BrowserAction browserAction = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
                    Clipboard systemcClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable clipboardContent = systemcClipboard.getContents(null);
                    if (clipboardContent == null) {
                        Hermes.ui.getDefaultMessageSink().add("Clipboard is empty");
                        break block11;
                    }
                    if (clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            String xml = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                            if (browserAction instanceof MessageStoreBrowserAction) {
                                if (HermesBrowser.getBrowser().getBrowserTree().getLastSelectedHermesTreeNode() != null) {
                                    MessageStoreBrowserAction storeAction = (MessageStoreBrowserAction)browserAction;
                                    Hermes messageFactory = HermesBrowser.getBrowser().getBrowserTree().getLastSelectedHermesTreeNode().getHermes();
                                    HermesBrowser.getBrowser().getThreadPool().invokeLater(new AddToMessageStoreTask(messageFactory, storeAction.getMessageStore(), xml));
                                } else {
                                    HermesBrowser.getBrowser().showErrorDialog("A session must be selected to use as a factory for the messages");
                                }
                                break block11;
                            }
                            HermesBrowser.getBrowser().getActionFactory().createSimpleSendMessageAction(browserAction.getHermes(), browserAction.getDestination(), browserAction.getDomain(), xml, false);
                        }
                        catch (Exception e) {
                            HermesBrowser.getBrowser().showErrorDialog("During paste: ", e);
                        }
                        break block11;
                    }
                    HermesBrowser.getBrowser().showErrorDialog("The data on the clipboard cannot be converted to a String");
                }
                catch (HeadlessException e) {
                    log.error((Object)("Cannot paste: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable e) {
                    HermesBrowser.getBrowser().showErrorDialog("During paste: ", e);
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
    }
}

