/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.JideSwingUtilities;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.MapPropertyDialog;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.swing.actions.ActionSupport;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.jms.JMSException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class GetDestinationStatisticsAction
extends ActionSupport {
    public GetDestinationStatisticsAction() {
        this.putValue("Name", "Properties...");
        this.putValue("ShortDescription", "Get properties and statistics from provider.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.statistics"));
        this.setEnabled(false);
        this.enableOnBrowserTreeSelection(new Class[]{DestinationConfigTreeNode.class}, (Action)this, true);
    }

    public void actionPerformed(ActionEvent arg0) {
        TreePath curPath = HermesBrowser.getBrowser().getBrowserTree().getSelectionModel().getSelectionPath();
        if (curPath != null && curPath.getLastPathComponent() instanceof DestinationConfigTreeNode) {
            final DestinationConfigTreeNode dNode = (DestinationConfigTreeNode)curPath.getLastPathComponent();
            final HermesTreeNode hNode = dNode.getHermesTreeNode();
            Hermes.ui.getDefaultMessageSink().add("Getting statistics for " + dNode.getDestinationName());
            Hermes.ui.getThreadPool().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Hermes hermes = null;
                    try {
                        hermes = hNode.getHermes();
                        final Map statistics = hermes.getStatistics(dNode.getConfig());
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MapPropertyDialog dialog = new MapPropertyDialog((Frame)((Object)HermesBrowser.getBrowser()), "Properties for " + dNode.getDestinationName(), null, statistics, false);
                                dialog.pack();
                                JideSwingUtilities.centerWindow((Window)((Object)dialog));
                                dialog.show();
                            }
                        });
                    }
                    catch (Throwable e) {
                        HermesBrowser.getBrowser().showErrorDialog("Can't get properties for " + dNode.getDestinationName(), e);
                    }
                    finally {
                        if (hermes != null) {
                            try {
                                hermes.close();
                            }
                            catch (JMSException e1) {}
                            Hermes.ui.getDefaultMessageSink().add("Ready.");
                        }
                    }
                }
            });
        }
    }
}

