/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.JideSwingUtilities;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.EditNamingConfigDialog;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.browser.model.tree.NamingConfigTreeNode;
import hermes.browser.tasks.EditDestinationPropertiesTask;
import hermes.swing.actions.ActionRegistry;
import hermes.swing.actions.ActionSupport;
import hermes.swing.actions.CreateNewJDBCAction;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditObjectAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(EditObjectAction.class);

    public EditObjectAction() {
        this.putValue("Name", "Edit...");
        this.putValue("ShortDescription", "Edit queue, topic, session or context.");
        this.putValue("SmallIcon", IconCache.getIcon("toolbarButtonGraphics/general/Edit16.gif"));
        this.setEnabled(false);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.enableOnBrowserTreeSelection(new Class[]{MessageStoreURLTreeNode.class, DestinationConfigTreeNode.class, HermesTreeNode.class, NamingConfigTreeNode.class}, (Action)this, false);
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            TreePath treePath = HermesBrowser.getBrowser().getBrowserTree().getSelectionModel().getSelectionPath();
            if (treePath != null) {
                Object component = treePath.getLastPathComponent();
                if (component instanceof DestinationConfigTreeNode) {
                    final DestinationConfigTreeNode node = (DestinationConfigTreeNode)component;
                    final HermesTreeNode hermesNode = node.getHermesTreeNode();
                    Hermes.ui.getThreadPool().invokeLater(new EditDestinationPropertiesTask(hermesNode.getHermes(), node.getConfig(), new Runnable(){

                        public void run() {
                            int index = hermesNode.getIndex(node);
                            hermesNode.remove(node);
                            HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereRemoved(hermesNode, new int[]{index}, new Object[]{node});
                            DestinationConfigTreeNode newNode = new DestinationConfigTreeNode(hermesNode, node.getConfig(), false);
                            hermesNode.add(newNode);
                            HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().nodesWereInserted(hermesNode, new int[]{hermesNode.getIndex(newNode)});
                            try {
                                HermesBrowser.getBrowser().saveConfig();
                            }
                            catch (Exception ex) {
                                HermesBrowser.getBrowser().showErrorDialog(ex);
                            }
                        }
                    }));
                } else if (component instanceof HermesTreeNode) {
                    HermesTreeNode hermesNode = (HermesTreeNode)component;
                    PreferencesDialog dialog = new PreferencesDialog((Frame)((Object)HermesBrowser.getBrowser()));
                    dialog.init();
                    dialog.refocus(hermesNode.getHermes().getId());
                    JideSwingUtilities.centerWindow((Window)dialog);
                    dialog.show();
                } else if (component instanceof NamingConfigTreeNode) {
                    NamingConfigTreeNode namingNode = (NamingConfigTreeNode)component;
                    EditNamingConfigDialog dialog = new EditNamingConfigDialog((Frame)((Object)HermesBrowser.getBrowser()), namingNode.getId(), HermesBrowser.getBrowser().getConfig().getNaming());
                    dialog.pack();
                    JideSwingUtilities.centerWindow((Window)((Object)dialog));
                    dialog.show();
                } else if (component instanceof MessageStoreURLTreeNode) {
                    MessageStoreURLTreeNode node = (MessageStoreURLTreeNode)component;
                    if (node.isConfigurable()) {
                        ActionRegistry.getAction(CreateNewJDBCAction.class).actionPerformed(new ActionEvent(node.getConfig(), 0, null));
                    } else {
                        HermesBrowser.getBrowser().showErrorDialog("You cannot edit the default message store");
                    }
                }
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog("Cannot edit: ", ex);
        }
    }
}

