/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.JideSwingUtilities;
import hermes.Domain;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.DestinationConfigDialog;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.config.DestinationConfig;
import hermes.swing.actions.ActionSupport;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public abstract class AddDestinationAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(AddDestinationAction.class);
    private Domain domain;

    public AddDestinationAction(Domain domain) {
        this.domain = domain;
        this.setEnabled(false);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.registerTreeSelection();
        }
    }

    protected void registerTreeSelection() {
        this.enableOnBrowserTreeSelection(new Class[]{HermesTreeNode.class}, (Action)this, true);
    }

    protected DestinationConfig createDestinationConfig() {
        return new DestinationConfig();
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            final HermesTreeNode hermesNode = HermesBrowser.getBrowser().getBrowserTree().getSelectedHermesNode();
            final DestinationConfig config = this.createDestinationConfig();
            config.setDomain(this.domain.getId());
            DestinationConfigDialog dialog = new DestinationConfigDialog((Frame)((Object)HermesBrowser.getBrowser()), hermesNode.getHermes().getId(), null, config);
            dialog.addOKAction(new Runnable(){

                public void run() {
                    try {
                        if (config.getName() != null) {
                            HermesBrowser.getBrowser().addDestinationConfig(hermesNode.getHermes(), config);
                            HermesBrowser.getBrowser().saveConfig();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), e.getMessage(), "Error", 0);
                    }
                }
            });
            dialog.pack();
            JideSwingUtilities.centerWindow((Window)((Object)dialog));
            dialog.show();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), ex.getMessage(), "Error", 0);
        }
    }
}

