/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing;

import com.jidesoft.swing.JideButton;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.FilterableAction;
import hermes.config.HermesConfig;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilterablePanel
extends JPanel {
    private JideButton deleteButton = new JideButton((Icon)IconCache.getIcon("hermes.delete"));
    private JideButton saveButton = new JideButton((Icon)IconCache.getIcon("hermes.save"));
    private JideButton clearButton = new JideButton((Icon)IconCache.getIcon("hermes.clear"));
    private Vector<String> filters = new Vector();

    public FilterablePanel() {
        this.init();
    }

    private void init() {
        try {
            this.filters.add("");
            this.filters.addAll(HermesBrowser.getBrowser().getConfig().getFilters());
        }
        catch (HermesException e1) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to load filter history", (Throwable)((Object)e1));
        }
        this.setLayout(new BoxLayout(this, 0));
        final JComboBox<String> comboBox = new JComboBox<String>(this.filters);
        comboBox.setEditable(true);
        this.add(new JLabel(" Filter: ", IconCache.getIcon("hermes.filter.sql"), 10));
        this.add(comboBox);
        this.add((Component)this.clearButton);
        this.add((Component)this.deleteButton);
        this.add((Component)this.saveButton);
        this.clearButton.setToolTipText("Clear any applied filter");
        this.deleteButton.setToolTipText("Delete this filter from saved filters");
        this.saveButton.setToolTipText("Add this filter to saved filters");
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterablePanel.this.doFilter((String)comboBox.getSelectedItem());
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (comboBox.getSelectedIndex() >= 0 && !TextUtils.isEmpty((String)comboBox.getSelectedItem()) && FilterablePanel.this.filters.contains(comboBox.getSelectedItem())) {
                    comboBox.removeItemAt(comboBox.getSelectedIndex());
                    FilterablePanel.this.updateFilterConfig();
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                comboBox.setSelectedItem("");
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String filter = (String)comboBox.getSelectedItem();
                if (!TextUtils.isEmpty(filter) && !FilterablePanel.this.filters.contains(filter)) {
                    comboBox.addItem(filter);
                    FilterablePanel.this.updateFilterConfig();
                }
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    private void doFilter(String filter) {
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof FilterableAction) {
            FilterableAction filterableAction = (FilterableAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            try {
                filterableAction.setSelector(filter);
            }
            catch (Throwable e) {
                HermesBrowser.getBrowser().showErrorDialog("Invalid selector: ", e);
            }
        }
    }

    private void updateFilterConfig() {
        try {
            HermesConfig config = HermesBrowser.getBrowser().getConfig();
            config.getFilters().clear();
            for (String filter : this.filters) {
                if (TextUtils.isEmpty(filter)) continue;
                config.getFilters().add(filter);
            }
            HermesBrowser.getBrowser().backupConfig();
            HermesBrowser.getBrowser().saveConfig();
        }
        catch (HermesException e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to update configuration", (Throwable)((Object)e));
        }
    }
}

