/*
 * Decompiled with CFR 0.152.
 */
package hermes.store;

import hermes.HermesException;
import hermes.store.MessageStore;
import hermes.store.SingleUserMessageStore;
import hermes.store.StoreUtils;
import hermes.store.schema.JDBCAdapter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.derby.impl.jdbc.EmbedSQLException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreManager {
    private static final Logger log = Logger.getLogger(MessageStoreManager.class);
    private static final Set<String> dbsCreated = new HashSet<String>();

    public static Collection<MessageStore> find() throws JMSException {
        return MessageStoreManager.find(StoreUtils.getDefaultConnectionURL());
    }

    public static MessageStore create(String storeId) throws JMSException {
        return MessageStoreManager.create(StoreUtils.getDefaultConnectionURL(), storeId);
    }

    public static MessageStore create(String url, String storeId) throws JMSException {
        return new SingleUserMessageStore(storeId, url, !dbsCreated.contains(url));
    }

    public static Collection<MessageStore> find(String url) throws JMSException {
        try {
            JDBCAdapter adapter = StoreUtils.getJDBCAdapter(url);
            Connection connection = DriverManager.getConnection(url);
            if (!dbsCreated.contains(url)) {
                adapter.createDatabase(connection);
                dbsCreated.add(url);
            }
            ArrayList<MessageStore> rval = new ArrayList<MessageStore>();
            for (String storeId : adapter.getStores(connection)) {
                rval.add(MessageStoreManager.create(url, storeId));
            }
            connection.close();
            return rval;
        }
        catch (SQLException e) {
            EmbedSQLException es;
            log.error((Object)e.getMessage(), (Throwable)e);
            if (e.getNextException() != null) {
                log.error((Object)e.getNextException().getMessage(), (Throwable)e.getNextException());
            }
            if (e instanceof EmbedSQLException && "XJ040.C".equals((es = (EmbedSQLException)e).getMessageId())) {
                throw new HermesException("Is another instance of HermesJMS running?", e);
            }
            throw new HermesException(e);
        }
    }
}

