/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import hermes.renderers.AbstractMessageRenderer;
import hermes.swing.MyTextArea;
import hermes.util.DumpUtils;
import hermes.util.MessageUtils;
import java.awt.Font;
import javax.jms.Message;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class HexMessageRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(HexMessageRenderer.class);

    public JComponent render(Message m) {
        MyTextArea textArea = new MyTextArea();
        textArea.setEditable(false);
        textArea.setFont(Font.decode("Monospaced-PLAIN-12"));
        byte[] bytes = null;
        try {
            bytes = MessageUtils.asBytes(m);
            textArea.setText(DumpUtils.dumpBinary(bytes, 4));
        }
        catch (Throwable e) {
            textArea.setText(e.getMessage());
            log.error((Object)"exception converting message to byte[]: ", e);
        }
        textArea.setCaretPosition(0);
        return textArea;
    }

    public boolean canRender(Message message) {
        return true;
    }

    public String getDisplayName() {
        return "Hex";
    }
}

