/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import com.codestreet.selector.Selector;
import com.codestreet.selector.jms.ValueProvider;
import com.codestreet.selector.parser.InvalidSelectorException;
import com.codestreet.selector.parser.Result;
import hermes.HermesException;
import hermes.MessageFactory;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.XMLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileQueue
implements Queue,
TemporaryQueue {
    private static XMLHelper xmlHelper = new DefaultXMLHelper();
    private File file;

    public FileQueue(File file) {
        this.file = file;
    }

    public FileQueue() throws IOException {
        this.file = File.createTempFile("hermes-queue", ".xml");
    }

    public String getQueueName() throws JMSException {
        return this.file.getName();
    }

    public Collection getMessages(MessageFactory messageFactory) throws JMSException, IOException {
        return xmlHelper.fromXML(messageFactory, new FileInputStream(this.file));
    }

    public Collection getMessages(MessageFactory messageFactory, String selector) throws JMSException, IOException {
        Collection<Message> messages = xmlHelper.fromXML(messageFactory, new FileInputStream(this.file));
        if (selector != null) {
            try {
                Selector selectorImpl = Selector.getInstance((String)selector);
                Iterator<Message> iter = messages.iterator();
                while (iter.hasNext()) {
                    Message message = iter.next();
                    if (selectorImpl.eval(ValueProvider.valueOf((Message)message), null) != Result.RESULT_FALSE) continue;
                    iter.remove();
                }
            }
            catch (InvalidSelectorException e) {
                throw new HermesException((Exception)((Object)e));
            }
        }
        return messages;
    }

    public void addMessages(MessageFactory messageFactory, Collection messages) throws JMSException, IOException {
        Collection c = this.getMessages(messageFactory, null);
        c.addAll(messages);
        xmlHelper.toXML(c, (OutputStream)new FileOutputStream(this.file));
    }

    public void delete() throws JMSException {
        this.file.delete();
    }

    public void delete(MessageFactory messageFactory, Collection<String> todelete) throws FileNotFoundException, JMSException {
        Collection<Message> messages = xmlHelper.fromXML(messageFactory, new FileInputStream(this.file));
        Iterator<Message> iter = messages.iterator();
        while (iter.hasNext()) {
            Message m = iter.next();
            if (!todelete.contains(m.getJMSMessageID())) continue;
            iter.remove();
        }
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof FileQueue) {
            FileQueue otherQueue = (FileQueue)other;
            return otherQueue.hashCode() == this.hashCode();
        }
        return false;
    }
}

