/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.pool;

import hermes.HermesException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    private static final Logger log = Logger.getLogger(ObjectPool.class);
    private List<T> pool = new ArrayList<T>();
    private int poolSize;

    public ObjectPool(int poolSize) {
        this.poolSize = poolSize;
    }

    public ObjectPool() {
        this(2);
    }

    protected abstract boolean beforeCheckin(T var1);

    protected abstract T makeObject() throws HermesException;

    protected abstract T newProxyInstance(T var1);

    protected abstract void closeObject(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T checkOutObject() throws HermesException {
        List<T> list = this.pool;
        synchronized (list) {
            if (this.pool.size() == 0) {
                log.debug((Object)"checkOutObject: pool is empty, creating new object...");
                return this.newProxyInstance(this.makeObject());
            }
            return this.newProxyInstance(this.pool.remove(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInObject(T object) throws HermesException {
        List<T> list = this.pool;
        synchronized (list) {
            if (this.pool.size() >= this.poolSize) {
                log.debug((Object)"checkInObject: pool is full, closing object...");
                this.closeObject(object);
            } else if (this.beforeCheckin(object)) {
                this.pool.add(object);
            } else {
                log.debug((Object)"checkInObject: beforeCheckin returned false, discarding object...");
            }
        }
    }

    public T get() throws HermesException {
        return this.checkOutObject();
    }
}

