/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import hermes.Hermes;
import hermes.JNDIQueueConnectionFactory;
import hermes.ProviderFailureException;
import hermes.impl.ConnectionFactoryManager;
import hermes.impl.ConnectionManager;
import hermes.impl.JMSManagerImpl;
import hermes.util.JMSUtils;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.log4j.Logger;

public abstract class ConnectionManagerSupport
extends JMSManagerImpl
implements ConnectionManager {
    private static final Logger log = Logger.getLogger(ConnectionManagerSupport.class);
    private String clientID;
    private String password;
    private String username;
    private Hermes hermes;

    public Hermes getHermes() {
        return this.hermes;
    }

    public void setHermes(Hermes hermes) {
        this.hermes = hermes;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected Connection createConnection() throws JMSException {
        return this.createConnection(this.username, this.password);
    }

    protected Connection createConnection(String username, String password) throws JMSException {
        ConnectionFactory connectionFactory = (ConnectionFactory)this.parent.getObject();
        Object rval = null;
        try {
            JNDIQueueConnectionFactory jndiCF;
            boolean isWebMethodsHack = false;
            if (connectionFactory instanceof JNDIQueueConnectionFactory && (jndiCF = (JNDIQueueConnectionFactory)connectionFactory).getInitialContextFactory() != null && jndiCF.getInitialContextFactory().equals("hermes.ext.wme.WMEInitialContextFactory")) {
                isWebMethodsHack = true;
            }
            if (!isWebMethodsHack) {
                rval = username == null ? connectionFactory.createConnection() : connectionFactory.createConnection(username, password);
                log.debug((Object)"connection created with JMS 1.1 interface");
            }
        }
        catch (NoSuchMethodError ex) {
        }
        catch (AbstractMethodError ex) {
            // empty catch block
        }
        if (rval == null) {
            rval = JMSUtils.isQueue(connectionFactory) ? (username == null ? ((QueueConnectionFactory)connectionFactory).createQueueConnection() : ((QueueConnectionFactory)connectionFactory).createQueueConnection(username, password)) : (username == null ? ((TopicConnectionFactory)connectionFactory).createTopicConnection() : ((TopicConnectionFactory)connectionFactory).createTopicConnection(username, password));
            log.debug((Object)"connection created with JMS 1.0.2b interface");
        }
        if (rval != null) {
            if (this.getClientID() != null && !this.getClientID().equals("")) {
                log.debug((Object)("calling setClientID(" + this.getClientID() + ") on the new connection"));
                rval.setClientID(this.getClientID());
            }
        } else {
            throw new ProviderFailureException("Internal provider error\nThe provider returned a null connection");
        }
        log.debug((Object)"calling start() on the new Connection");
        rval.start();
        Hermes.events.notifyConnected(this.hermes);
        return rval;
    }

    public ConnectionFactoryManager getConnectionFactoryManager() {
        return (ConnectionFactoryManager)this.getParent();
    }

    public String getClientID() {
        return this.clientID;
    }
}

