/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import org.apache.commons.beanutils.BeanUtils;

public class DestinationConfigKeyWrapper {
    private DestinationConfig config;
    private Hermes hermes;

    public DestinationConfigKeyWrapper(Hermes hermes, DestinationConfig config) {
        this.config = config;
        this.hermes = hermes;
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this.config).toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public DestinationConfigKeyWrapper(DestinationConfig config) {
        this(null, config);
    }

    public DestinationConfigKeyWrapper(String destinationName, Domain domain) {
        this.config = HermesBrowser.getConfigDAO().createDestinationConfig(destinationName, domain);
    }

    public Hermes getHermes() {
        return this.hermes;
    }

    public DestinationConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DestinationConfigKeyWrapper) {
            DestinationConfigKeyWrapper other = (DestinationConfigKeyWrapper)obj;
            if ((this.hermes == null || this.hermes.getId().equals(other.hermes.getId())) && this.config.getDomain() == other.config.getDomain() && this.config.getName().equals(other.config.getName()) && (this.config.getSelector() == null && other.config.getSelector() == null || this.config.getSelector().equals(other.config.getSelector()))) {
                if (this.config.getDomain().intValue() == Domain.TOPIC.getId()) {
                    if (this.config.isDurable() && other.config.isDurable()) {
                        return this.config.getClientID() != null && this.config.getClientID().equals(other.config.getClientID());
                    }
                    if (!this.config.isDurable() && !other.config.isDurable()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Domain.getDomain(this.config.getDomain())).append(this.config.getName()).append(this.config.getSelector());
        if (this.config.getDomain().intValue() == Domain.TOPIC.getId()) {
            buffer.append(this.config.isDurable()).append(this.config.getClientID());
        }
        return buffer.toString().hashCode();
    }
}

