/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import hermes.fix.FIXMessage;
import hermes.fix.FIXPrettyPrinter;
import java.util.Map;
import quickfix.Field;

public class CompactFIXPrettyPrinter
implements FIXPrettyPrinter {
    public String print(FIXMessage message) {
        StringBuffer rval = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append(message.getString(49)).append(" -> ").append(message.getString(56)).append(":");
        Map<Integer, Field> fields = message.getAllFields();
        for (Map.Entry<Integer, Field> entry : fields.entrySet()) {
            if (line.length() > 80) {
                rval.append(line).append("\n");
                line = new StringBuffer();
            }
            Field field = entry.getValue();
            Object fieldValue = message.getObject(entry.getValue());
            String fieldValueName = message.getDictionary().getValueName(field.getTag(), fieldValue.toString());
            String tagText = message.getDictionary().getFieldName(field.getTag()) + "<" + field.getTag() + ">=" + fieldValue.toString();
            if (fieldValueName != null) {
                tagText = tagText + "<" + fieldValueName + ">";
            }
            if (line.length() != 0) {
                line.append(" ");
            } else {
                line.append("    ");
            }
            line.append(tagText);
        }
        if (line.length() > 0) {
            rval.append(line);
        }
        return rval.toString();
    }
}

