/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import hermes.HermesRuntimeException;
import hermes.browser.transferable.MessageGroup;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.log4j.Category;

public class JMSMessagesTransferable
implements Transferable {
    private static final Category cat = Category.getInstance(JMSMessagesTransferable.class);
    private static DataFlavor[] flavors;
    public static final DataFlavor FLAVOR;
    private MessageGroup messages;

    public JMSMessagesTransferable(MessageGroup messages) {
        this.messages = messages;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor arg0) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(arg0)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        if (flavour.equals(DataFlavor.stringFlavor) || flavour.getRepresentationClass().equals(String.class)) {
            try {
                return this.messages.getHermes().toXML(this.messages.getSelectedMessages());
            }
            catch (JMSException e) {
                if (e.getLinkedException() instanceof IOException) {
                    throw (IOException)e.getLinkedException();
                }
                throw new HermesRuntimeException((Exception)((Object)e));
            }
        }
        if (flavour.isMimeTypeEqual(FLAVOR)) {
            return this.messages;
        }
        throw new UnsupportedFlavorException(flavour);
    }

    static {
        FLAVOR = new DataFlavor(JMSMessagesTransferable.class, "JMS Messages");
        try {
            flavors = new DataFlavor[]{DataFlavor.stringFlavor, FLAVOR};
        }
        catch (Exception ex) {
            cat.error((Object)("unable to initialise message drag and drop:" + ex.getMessage()), (Throwable)ex);
        }
    }
}

