/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.browser.HermesBrowser;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.store.MessageStore;
import hermes.store.MessageStoreManager;
import java.util.Collection;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;

public class UpdateMessageStoresTask
implements Runnable {
    private MessageStoreURLTreeNode parent;
    private BrowserTreeModel model;

    public UpdateMessageStoresTask(BrowserTreeModel model, MessageStoreURLTreeNode parent) {
        this.model = model;
        this.parent = parent;
    }

    public void run() {
        try {
            Collection<MessageStore> stores = MessageStoreManager.find(this.parent.getURL());
            for (final MessageStore store : stores) {
                for (int i = 0; i < this.parent.getChildCount(); ++i) {
                    MessageStoreTreeNode existing;
                    if (!(this.parent.getChildAt(i) instanceof MessageStoreTreeNode) || !(existing = (MessageStoreTreeNode)this.parent.getChildAt(i)).getMessageStore().getId().equals(store.getId())) continue;
                    this.parent.remove(i);
                    existing.close();
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UpdateMessageStoresTask.this.parent.add(new MessageStoreTreeNode(UpdateMessageStoresTask.this.model, store.getId(), store));
                        UpdateMessageStoresTask.this.model.nodesWereInserted(UpdateMessageStoresTask.this.parent, new int[]{UpdateMessageStoresTask.this.parent.getChildCount() - 1});
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                }
            });
        }
        catch (JMSException e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to find any message stores", e);
        }
    }
}

