/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.swing.SwingRunner;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageTask
extends TaskSupport {
    private static final Logger cat = Logger.getLogger(SendMessageTask.class);
    public static final int IS_XML = 0;
    public static final int IS_TEXT = 1;
    public static final int MAYBE_XML = 2;
    private Hermes hermes;
    private String destinationName;
    private String content;
    private List files;
    private Set messageDelimiters = new HashSet();
    private Domain domain;
    private int isXML = 0;
    private int uploaded = 0;
    private int persistence = HermesBrowser.getBrowser().getSendPersistence();
    private boolean preserveDestination = false;

    public SendMessageTask(Hermes hermes, String destinationName, Domain domain, String content, boolean preserveDestination) {
        super(IconCache.getIcon("hermes.messages.send"));
        this.hermes = hermes;
        this.destinationName = destinationName;
        this.content = content;
        this.domain = domain;
        this.preserveDestination = preserveDestination;
    }

    public SendMessageTask(Hermes hermes, String destinationName, Domain domain, File file, int isXML, boolean preserveDestination) {
        super(IconCache.getIcon("hermes.messages.send"));
        this.hermes = hermes;
        this.destinationName = destinationName;
        this.files = new ArrayList();
        this.isXML = isXML;
        this.domain = domain;
        this.preserveDestination = preserveDestination;
        this.files.add(file);
    }

    @Override
    public String getTitle() {
        return "Send";
    }

    public SendMessageTask(Hermes hermes, String destinationName, Domain domain, List files, int isXML, boolean preserveDestination) {
        super(IconCache.getIcon("hermes.messages.send"));
        this.hermes = hermes;
        this.destinationName = destinationName;
        this.files = files;
        this.isXML = isXML;
        this.domain = domain;
        this.preserveDestination = preserveDestination;
    }

    private void doUpload(Destination to, Iterator<Message> messages) throws JMSException {
        while (messages.hasNext()) {
            Message m = messages.next();
            if (this.preserveDestination && m.getJMSDestination() != null) {
                this.hermes.send(m.getJMSDestination(), m);
            } else {
                this.hermes.send(to, m);
            }
            ++this.uploaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws Exception {
        InputStream istream = null;
        try {
            Destination to = this.hermes.getDestination(this.destinationName, this.domain);
            if (this.files != null) {
                for (File file : this.files) {
                    ArrayList<TextMessage> messages = null;
                    if (this.isXML == 0 || this.isXML == 2) {
                        istream = new FileInputStream(file);
                        try {
                            messages = this.hermes.fromXML(istream);
                        }
                        catch (Exception ex) {
                            if (this.isXML != 2) {
                                throw ex;
                            }
                            cat.info((Object)("file was not XML, trying as a normal text: " + ex.getMessage()), (Throwable)ex);
                        }
                        finally {
                            istream.close();
                        }
                    }
                    if (this.isXML == 1 || this.isXML == 2 && (messages == null || messages.size() == 0)) {
                        String line;
                        istream = new FileInputStream(file);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
                        StringWriter payload = new StringWriter();
                        while ((line = reader.readLine()) != null) {
                            payload.append(line).append('\n');
                        }
                        reader.close();
                        messages = new ArrayList<TextMessage>();
                        TextMessage message = this.hermes.createTextMessage(payload.toString());
                        message.setJMSDestination(to);
                        messages.add(message);
                    }
                    this.doUpload(to, messages.iterator());
                    istream.close();
                }
            } else if (this.content != null) {
                final Collection messages = this.hermes.fromXML(this.content);
                SendMessageTask sendMessageTask = this;
                synchronized (sendMessageTask) {
                    SwingRunner.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (messages.size() > 0) {
                                if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Are you sure you wish to send the " + messages.size() + (messages.size() > 1 ? " messages" : " message") + " from the clipboard to " + SendMessageTask.this.destinationName + " ?", "Warning", 0) != 0) {
                                    SendMessageTask.this.stop();
                                    SendMessageTask.this.notifyStatus("Send to" + SendMessageTask.this.destinationName + " cancelled");
                                }
                                SendMessageTask sendMessageTask = SendMessageTask.this;
                                synchronized (sendMessageTask) {
                                    SendMessageTask.this.notify();
                                }
                            } else {
                                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), "No messages on the clipboard.", "Cannot Send", 0);
                            }
                        }
                    });
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                this.doUpload(to, messages.iterator());
            }
            this.hermes.commit();
            if (this.uploaded == 1) {
                this.notifyStatus("One message uploaded.");
            } else {
                this.notifyStatus(new String(this.uploaded + " messages uploaded to " + this.destinationName));
            }
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    cat.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.hermes.close();
        }
    }
}

