/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.config.DestinationConfig;
import hermes.store.MessageStore;
import hermes.util.JMSUtils;
import hermes.util.TextUtils;
import java.awt.Component;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ReplayMessagesFromStoreTask
extends TaskSupport {
    private MessageStore messageStore;
    private Destination sourceDestination;
    private Hermes hermes;
    private DestinationConfig targetDestinationConfig;
    private int messagesSent = 0;

    public ReplayMessagesFromStoreTask(MessageStore messageStore, Destination sourceDestination, Hermes hermes, DestinationConfig targetDestinationConfig) {
        super(IconCache.getIcon("hermes.replay"));
        this.messageStore = messageStore;
        this.sourceDestination = sourceDestination;
        this.hermes = hermes;
        this.targetDestinationConfig = targetDestinationConfig;
    }

    public ReplayMessagesFromStoreTask(MessageStore messageStore, Hermes hermes, DestinationConfig targetDestinationConfig) {
        this(messageStore, null, hermes, targetDestinationConfig);
    }

    public ReplayMessagesFromStoreTask(MessageStore messageStore, Hermes hermes) {
        this(messageStore, null, hermes, null);
    }

    public String getTitle() {
        return "Replaying from " + this.messageStore.getId() + " to " + this.hermes.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        ReplayMessagesFromStoreTask replayMessagesFromStoreTask = this;
        synchronized (replayMessagesFromStoreTask) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Are you sure you wish to replay message(s) to " + ReplayMessagesFromStoreTask.this.hermes.getId() + "?", "Warning", 0) != 0) {
                        ReplayMessagesFromStoreTask.this.stop();
                        ReplayMessagesFromStoreTask.this.notifyStatus("Replay cancelled");
                    }
                    ReplayMessagesFromStoreTask replayMessagesFromStoreTask = ReplayMessagesFromStoreTask.this;
                    synchronized (replayMessagesFromStoreTask) {
                        ReplayMessagesFromStoreTask.this.notify();
                    }
                }
            });
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        QueueBrowser browser = null;
        try {
            if (this.isRunning()) {
                Hermes.ui.getDefaultMessageSink().add(this.getTitle() + "...");
                Destination targetDestination = null;
                if (this.targetDestinationConfig != null) {
                    targetDestination = this.hermes.getDestination(this.targetDestinationConfig.getName(), Domain.getDomain(this.targetDestinationConfig.getDomain()));
                }
                MessageStore.HeaderPolicy headerPolicy = targetDestination == null ? MessageStore.HeaderPolicy.DESTINATION_ONLY : MessageStore.HeaderPolicy.NO_HEADER;
                browser = this.sourceDestination == null ? this.messageStore.visit(this.hermes, headerPolicy) : this.messageStore.visit(this.hermes, this.sourceDestination, headerPolicy);
                Enumeration iter = browser.getEnumeration();
                while (iter.hasMoreElements() && this.isRunning()) {
                    Message message = (Message)iter.nextElement();
                    if (message != null) {
                        if (targetDestination != null) {
                            message.setJMSDestination(targetDestination);
                        }
                        this.hermes.send(message.getJMSDestination(), message);
                        if (this.hermes.getTransacted()) {
                            this.hermes.commit();
                        }
                    }
                    ++this.messagesSent;
                }
                Hermes.ui.getDefaultMessageSink().add("Replayed " + this.messagesSent + " message" + TextUtils.plural(this.messagesSent) + " to " + this.hermes.getId());
            }
        }
        finally {
            JMSUtils.closeQuietly(browser);
            this.hermes.close();
        }
    }
}

