/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.fix.ChainByClOrdID;
import hermes.fix.FIXMessageListener;
import hermes.fix.FIXMessageTable;
import hermes.util.TextUtils;
import org.apache.log4j.Logger;

public class BrowseFIXChainTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(BrowseFIXChainTask.class);
    private FIXMessageTable source;
    private FIXMessageListener target;
    private int startRow;
    private String clOrdID;

    public BrowseFIXChainTask(FIXMessageTable source, FIXMessageListener target, String clOrdID, int startRow) {
        super(IconCache.getIcon("hermes.file.fix"));
        this.source = source;
        this.target = target;
        this.clOrdID = clOrdID;
        this.startRow = startRow;
    }

    public String getTitle() {
        return this.clOrdID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        int nmessages = 0;
        ChainByClOrdID chain = new ChainByClOrdID(this.source);
        try {
            nmessages = chain.filterByClOrdID(this.clOrdID, this.target, this.startRow);
        }
        catch (Exception ex) {
            log.error((Object)("chain stopped: " + ex.getMessage()));
        }
        finally {
            log.debug((Object)("nmessages=" + nmessages));
        }
        this.notifyStatus("Found " + nmessages + " message" + TextUtils.plural(nmessages));
    }
}

