/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.browser.HermesBrowser;
import hermes.browser.model.BeanTableModel;
import hermes.config.PropertyConfig;
import hermes.config.PropertySetConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class PropertySetTableModel
extends AbstractTableModel {
    private static Set ignore = new HashSet();
    private static final Logger log = Logger.getLogger(BeanTableModel.class);
    private PropertySetConfig propertySet;
    private Map filter;
    private Vector rows = new Vector();
    private String[] columns = new String[]{"Property", "Value"};
    private Object bean;
    private Map beanProperties;

    public PropertySetTableModel(Object bean, PropertySetConfig propertySet, Set filter) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.propertySet = propertySet;
        Object iterSet = null;
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        if (propertySet.getProperty() != null) {
            for (PropertyConfig property : propertySet.getProperty()) {
                if (ignore.contains(property.getName())) continue;
                String propertyValue = property.getValue();
                if (propertyValue == null) {
                    propertyValue = "null";
                }
                sortMap.put(property.getName(), propertyValue);
            }
            for (Map.Entry entry : sortMap.entrySet()) {
                Vector<Object> row = new Vector<Object>();
                row.add(entry.getKey());
                row.add(entry.getValue());
                this.rows.add(row);
            }
        }
        this.setBean(bean);
    }

    public void setBean(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.beanProperties = BeanUtils.describe((Object)bean);
        Iterator iter = ignore.iterator();
        while (iter.hasNext()) {
            this.beanProperties.remove(iter.next());
        }
        iter = this.rows.iterator();
        while (iter.hasNext()) {
            Vector row = (Vector)iter.next();
            String propertyName = (String)row.elementAt(0);
            if (propertyName != null && !propertyName.equals("") && this.isValidProperty(propertyName)) continue;
            log.debug((Object)(propertyName + " is not a valid property for " + bean.getClass().getName() + " - removed"));
            iter.remove();
        }
        this.fireTableDataChanged();
    }

    public Set getValidProperties() {
        return this.beanProperties.keySet();
    }

    public boolean isValidProperty(String propertyName) {
        return this.getValidProperties().contains(propertyName);
    }

    public void insertRow() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Vector<String> row = new Vector<String>();
        row.add("");
        row.add("");
        this.rows.add(row);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size());
    }

    public void removeRow(int index) {
        if (index < this.rows.size()) {
            Vector vector = (Vector)this.rows.remove(index);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getValueAt(int arg0, int arg1) {
        Vector row = (Vector)this.rows.elementAt(arg0);
        return row.elementAt(arg1);
    }

    public String getColumnName(int x) {
        return this.columns[x];
    }

    public boolean isCellEditable(int y, int x) {
        return true;
    }

    public void setValueAt(Object value, int y, int x) {
        Object propertyValue;
        String propertyName;
        Vector row = (Vector)this.rows.elementAt(y);
        if (x == 0) {
            propertyName = (String)value;
            propertyValue = row.elementAt(1);
            if (this.isValidProperty(propertyName)) {
                row.set(0, value);
            } else {
                log.error((Object)(propertyName + " is not a valid property for " + this.bean.getClass().getName()));
            }
        } else {
            propertyName = (String)row.elementAt(0);
            propertyValue = value;
            row.set(1, value);
        }
        log.debug((Object)("set (cached) " + propertyName + "=" + propertyValue.toString()));
        this.fireTableCellUpdated(y, x);
    }

    public List getProperties() throws JAXBException {
        ArrayList<PropertyConfig> list = new ArrayList<PropertyConfig>();
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Vector row = (Vector)iter.next();
            String key = (String)row.elementAt(0);
            String value = (String)row.elementAt(1);
            if (key != null && !key.equals("")) {
                PropertyConfig pConfig = HermesBrowser.getConfigDAO().getFactory().createPropertyConfig();
                pConfig.setName(key);
                pConfig.setValue(value);
                list.add(pConfig);
                continue;
            }
            iter.remove();
        }
        return list;
    }

    static {
        ignore.add("class");
    }
}

