/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import com.codestreet.selector.jms.ValueProvider;
import com.codestreet.selector.parser.IValueProvider;
import hermes.Hermes;
import hermes.HermesException;
import hermes.HermesRuntimeException;
import hermes.browser.HermesBrowser;
import hermes.swing.HideableTableColumn;
import hermes.swing.RowValueProvider;
import hermes.util.JMSUtils;
import java.util.Date;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class MessageHeaderTableModel
extends DefaultTableModel
implements RowValueProvider {
    private static final Logger log = Logger.getLogger(MessageHeaderTableModel.class);
    private final Vector<Vector> rows = new Vector();
    private final Vector<Message> messages = new Vector();
    private final Hermes hermes;
    private String destinationName;
    private Vector<HideableTableColumn> userProperties = new Vector();

    public MessageHeaderTableModel(Hermes hermes, String destinationName) {
        this.hermes = hermes;
        this.destinationName = destinationName;
        this.addColumn("#");
        this.addColumn("JMSMessageId");
        this.addColumn("JMSDestination");
        this.addColumn("JMSTimestamp");
        this.addColumn("JMSType");
        this.addColumn("JMSReplyTo");
        this.addColumn("JMSCorrelationID");
        this.addColumn("JMSExpiration");
        this.addColumn("JMSPriority");
    }

    public IValueProvider getValueProviderForRow(int row) {
        return ValueProvider.valueOf((Message)this.messages.get(row));
    }

    public Message getMessageAt(int row) {
        return this.messages.elementAt(row);
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void clear() {
        this.rows.clear();
        this.messages.clear();
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 9 + this.userProperties.size();
    }

    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    public Object getValueAt(int y, int x) {
        if (this.rows.size() > y) {
            Vector row = this.rows.elementAt(y);
            return row.elementAt(x);
        }
        return null;
    }

    public void removeFirstRow() {
        this.rows.remove(0);
        this.messages.remove(0);
        this.fireTableRowsDeleted(0, 1);
    }

    private Vector createRow(int messageIndex, Message message) throws JMSException {
        Vector<Object> newRow = new Vector<Object>();
        newRow.add(new Long(messageIndex));
        newRow.add(message.getJMSMessageID());
        try {
            if (message.getJMSDestination() != null) {
                newRow.add(JMSUtils.getDestinationName(message.getJMSDestination()));
            } else {
                newRow.add(this.destinationName);
            }
        }
        catch (Exception ex) {
            log.error((Object)("cannot get JMSDestination: " + ex.getMessage()));
            newRow.add("Unknown");
        }
        try {
            newRow.add(new Date(message.getJMSTimestamp()));
        }
        catch (Exception ex) {
            newRow.add(new Date());
            log.error((Object)("no JMSTimestamp in message: " + ex.getMessage()));
        }
        try {
            newRow.add(message.getJMSType());
        }
        catch (Exception ex) {
            log.error((Object)("no JMSType in message: " + ex.getMessage()));
            newRow.add("");
        }
        try {
            if (message.getJMSReplyTo() != null) {
                newRow.add(JMSUtils.getDestinationName(message.getJMSReplyTo()));
            } else {
                newRow.add("");
            }
        }
        catch (Exception ex) {
            log.error((Object)("no JMSReplyTo in message: " + ex.getMessage()));
            newRow.add("");
        }
        try {
            newRow.add(message.getJMSCorrelationID());
        }
        catch (Exception ex) {
            log.error((Object)("no JMSCorrelationID in message: " + ex.getMessage()));
            newRow.add("");
        }
        try {
            newRow.add(new Long(message.getJMSExpiration()));
        }
        catch (Exception ex) {
            log.error((Object)("no JMSExpiration in message: " + ex.getMessage()));
            newRow.add("");
        }
        try {
            newRow.add(message.getJMSPriority());
        }
        catch (Exception ex) {
            log.error((Object)("no JMSPriority in message: " + ex.getMessage()));
            newRow.add("");
        }
        return newRow;
    }

    public void setFinalMessageIndex(int messageIndex) {
        try {
            if (messageIndex == -1) {
                if (this.rows.size() > 0) {
                    this.rows.clear();
                    this.messages.clear();
                    this.fireTableDataChanged();
                }
            } else if (messageIndex != this.rows.size() - 1 && (HermesBrowser.getBrowser().getMaxMessagesInBrowserPane() == -1 || messageIndex < HermesBrowser.getBrowser().getMaxMessagesInBrowserPane())) {
                int lastRow = this.rows.size() - 1;
                while (this.rows.size() != messageIndex + 1 && this.rows.size() > 0) {
                    this.rows.remove(this.rows.size() - 1);
                    this.messages.remove(this.messages.size() - 1);
                }
                this.fireTableDataChanged();
            }
        }
        catch (HermesException ex) {
            throw new HermesRuntimeException((Exception)((Object)ex));
        }
    }

    public void addMessage(int messageIndex, Message message) throws JMSException {
        if (messageIndex < this.rows.size()) {
            Message existingMessage = this.messages.elementAt(messageIndex);
            if (existingMessage.getJMSMessageID().equals(message.getJMSMessageID())) {
                return;
            }
            this.rows.setElementAt(this.createRow(messageIndex, message), messageIndex);
            this.messages.setElementAt(message, messageIndex);
            this.fireTableRowsUpdated(messageIndex, messageIndex);
            return;
        }
        this.rows.add(this.createRow(messageIndex, message));
        this.messages.add(message);
        this.fireTableRowsInserted(messageIndex, messageIndex);
    }

    public String getColumnName(int arg0) {
        switch (arg0) {
            case 0: {
                return "#";
            }
            case 1: {
                return "JMSMessageID";
            }
            case 2: {
                return "JMSDestination";
            }
            case 3: {
                return "JMSTimestamp";
            }
            case 4: {
                return "JMSType";
            }
            case 5: {
                return "JMSReplyTo";
            }
            case 6: {
                return "JMSCorrelationID";
            }
            case 7: {
                return "JMSExpiration";
            }
            case 8: {
                return "JMSPriority";
            }
        }
        return super.getColumnName(arg0);
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return Long.class;
            }
            case 8: {
                return Integer.class;
            }
        }
        return super.getColumnClass(column);
    }

    public Object getChildValueAt(int row) {
        return this.getMessageAt(row);
    }
}

