/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.ConnectionListener;
import hermes.Hermes;
import hermes.HermesConfigurationListener;
import hermes.HermesException;
import hermes.HermesRepository;
import hermes.HermesRepositoryListener;
import hermes.HermesRuntimeException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.model.TreeUtils;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.DestinationFragmentTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.model.tree.HermesTreeNodeComparator;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.browser.model.tree.NamingConfigTreeNode;
import hermes.browser.model.tree.RepositoryTreeNode;
import hermes.browser.tasks.UpdateMessageStoresTask;
import hermes.config.DestinationConfig;
import hermes.config.JDBCStore;
import hermes.config.NamingConfig;
import hermes.config.WatchConfig;
import hermes.impl.DestinationConfigKeyWrapper;
import hermes.store.MessageStore;
import hermes.store.StoreUtils;
import hermes.swing.SwingRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TreeMap;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserTreeModel
extends DefaultTreeModel
implements HermesConfigurationListener,
HermesRepositoryListener,
ConnectionListener {
    private static final Category cat = Category.getInstance(BrowserTreeModel.class);
    private static final Timer timer = new Timer();
    private DefaultMutableTreeNode ctxRootNode = new DefaultMutableTreeNode("contexts");
    private Map<DestinationConfigKeyWrapper, DestinationConfigTreeNode> destinationMap = new HashMap<DestinationConfigKeyWrapper, DestinationConfigTreeNode>();
    private Map<String, MessageStoreURLTreeNode> stores = new HashMap<String, MessageStoreURLTreeNode>();
    private Map<String, HermesTreeNode> hermesMap = new TreeMap<String, HermesTreeNode>();
    private DefaultMutableTreeNode jmsRootNode = new DefaultMutableTreeNode("sessions");
    private Map<String, NamingConfigTreeNode> namingNodeById = new HashMap<String, NamingConfigTreeNode>();
    private Map<HermesRepository, RepositoryTreeNode> rep2Node = new HashMap<HermesRepository, RepositoryTreeNode>();
    private DefaultMutableTreeNode repositoryNode = new DefaultMutableTreeNode("files");
    private DefaultMutableTreeNode storesNode = new DefaultMutableTreeNode("stores");
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("jms");

    public BrowserTreeModel() throws HermesException {
        super(new DefaultMutableTreeNode());
        this.setRoot(this.rootNode);
        this.rootNode.removeAllChildren();
        this.jmsRootNode.removeAllChildren();
        this.ctxRootNode.removeAllChildren();
        this.rootNode.add(this.jmsRootNode);
        this.rootNode.add(this.ctxRootNode);
        this.rootNode.add(this.storesNode);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.rootNode.add(this.repositoryNode);
        }
        if (!HermesBrowser.getBrowser().isMessageStoresDisabled()) {
            MessageStoreURLTreeNode localURLNode = new MessageStoreURLTreeNode("local", StoreUtils.getDefaultConnectionURL());
            this.addMessageStoreURLTreeNode(localURLNode);
        }
        for (JDBCStore storeConfig : HermesBrowser.getBrowser().getConfig().getJdbcStore()) {
            try {
                this.addMessageStoreURLTreeNode(new MessageStoreURLTreeNode(storeConfig));
            }
            catch (ClassNotFoundException ex) {
                HermesBrowser.getBrowser().showErrorDialog("Cannot load JDBC driver " + storeConfig.getDriver());
            }
        }
        Hermes.events.addConnectionListener(this);
    }

    public NamingConfigTreeNode getNamingConfigTreeNode(String name) throws HermesException {
        if (this.namingNodeById.containsKey(name)) {
            return this.namingNodeById.get(name);
        }
        throw new HermesException("No such naming configuration " + name);
    }

    public void addMessageStoreURLTreeNode(MessageStoreURLTreeNode node) {
        this.stores.put(node.getURL(), node);
        this.storesNode.add(node);
        this.nodesWereInserted(this.storesNode, new int[]{this.storesNode.getChildCount() - 1});
        HermesBrowser.getBrowser().getThreadPool().invokeLater(new UpdateMessageStoresTask(this, node));
    }

    @Override
    public void onConnectionClosed(Hermes hermes) {
        if (this.hermesMap.containsKey(hermes.getId())) {
            HermesTreeNode node = this.hermesMap.get(hermes.getId());
            node.setConnectionOpen(false);
        } else {
            cat.error((Object)("onConnectionClosed(), no such Hermes id=" + hermes.getId()));
        }
    }

    @Override
    public void onConnectionOpen(Hermes hermes) {
        if (this.hermesMap.containsKey(hermes.getId())) {
            HermesTreeNode node = this.hermesMap.get(hermes.getId());
            node.setConnectionOpen(true);
        } else {
            cat.error((Object)("onConnectionOpen(), no such Hermes id=" + hermes.getId()));
        }
    }

    public Collection<MessageStore> getMessageStores() {
        ArrayList<MessageStore> stores = new ArrayList<MessageStore>();
        for (int i = 0; i < this.storesNode.getChildCount(); ++i) {
            if (!(this.storesNode.getChildAt(i) instanceof MessageStoreURLTreeNode)) continue;
            MessageStoreURLTreeNode urlNode = (MessageStoreURLTreeNode)this.storesNode.getChildAt(i);
            for (int j = 0; j < urlNode.getChildCount(); ++j) {
                MessageStoreTreeNode node = (MessageStoreTreeNode)urlNode.getChildAt(j);
                stores.add(node.getMessageStore());
            }
        }
        return stores;
    }

    public HermesTreeNode getFirstHermesTreeNode() {
        Iterator<Map.Entry<String, HermesTreeNode>> iter = this.hermesMap.entrySet().iterator();
        return iter.hasNext() ? iter.next().getValue() : null;
    }

    public void onMessageStoreAdded(final MessageStore store) {
        SwingRunner.invokeLater(new Runnable(){

            public void run() {
                MessageStoreURLTreeNode parent = (MessageStoreURLTreeNode)BrowserTreeModel.this.stores.get(store.getURL());
                if (parent == null) {
                    throw new HermesRuntimeException("Cannot find JDBC URL " + store.getURL());
                }
                parent.add(new MessageStoreTreeNode(BrowserTreeModel.this, store.getId(), store));
                BrowserTreeModel.this.nodeStructureChanged(parent);
            }
        });
    }

    public void onMessageStoreRemoved(final MessageStore store) {
        SwingRunner.invokeLater(new Runnable(){

            public void run() {
                MessageStoreURLTreeNode parent = (MessageStoreURLTreeNode)BrowserTreeModel.this.stores.get(store.getURL());
                if (parent != null) {
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        MessageStoreTreeNode node;
                        if (!(parent.getChildAt(i) instanceof MessageStoreTreeNode) || !(node = (MessageStoreTreeNode)parent.getChildAt(i)).getId().equals(store.getId())) continue;
                        parent.remove(i);
                        BrowserTreeModel.this.nodeStructureChanged(parent);
                        break;
                    }
                }
            }
        });
    }

    public Collection<String> getAllHermesIds() {
        return this.hermesMap.keySet();
    }

    @Override
    public void onDestinationAdded(final Hermes hermes, final DestinationConfig destinationConfig) {
        SwingRunner.invokeLater(new Runnable(){

            public void run() {
                block8: {
                    if (BrowserTreeModel.this.hermesMap.containsKey(hermes.getId())) {
                        HermesTreeNode cfNode = (HermesTreeNode)BrowserTreeModel.this.hermesMap.get(hermes.getId());
                        DestinationConfigTreeNode dNode = new DestinationConfigTreeNode(cfNode, destinationConfig, cfNode.isCascadeNamespace());
                        DestinationConfigKeyWrapper key = new DestinationConfigKeyWrapper(hermes, destinationConfig);
                        if (BrowserTreeModel.this.destinationMap.containsKey(key)) {
                            cat.error((Object)("duplicate destination key=" + key));
                        } else {
                            BrowserTreeModel.this.destinationMap.put(key, dNode);
                            if (cfNode.isCascadeNamespace()) {
                                try {
                                    if (cfNode.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
                                        TreeUtils.add(BrowserTreeModel.this, cfNode.getHermes(), destinationConfig.getName(), "/", cfNode, dNode);
                                        break block8;
                                    }
                                    TreeUtils.add(BrowserTreeModel.this, cfNode.getHermes(), destinationConfig.getName(), ".", cfNode, dNode);
                                }
                                catch (JMSException ex) {
                                    HermesBrowser.getBrowser().showErrorDialog(ex);
                                }
                            } else {
                                cfNode.add(dNode);
                                BrowserTreeModel.this.nodesWereInserted(cfNode, new int[]{cfNode.getIndex(dNode)});
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onDestinationRemoved(final Hermes hermes, final DestinationConfig destinationConfig) {
        SwingRunner.invokeLater(new Runnable(){

            public void run() {
                if (BrowserTreeModel.this.hermesMap.containsKey(hermes.getId())) {
                    DestinationConfigTreeNode node;
                    HermesTreeNode cfNode = (HermesTreeNode)BrowserTreeModel.this.hermesMap.get(hermes.getId());
                    DestinationConfigKeyWrapper key = new DestinationConfigKeyWrapper(hermes, destinationConfig);
                    if (BrowserTreeModel.this.destinationMap.containsKey(key) && (node = (DestinationConfigTreeNode)BrowserTreeModel.this.destinationMap.remove(key)) != null) {
                        if (node.getParent() == cfNode) {
                            int index = cfNode.getIndex(node);
                            cfNode.remove(node);
                            BrowserTreeModel.this.nodesWereRemoved(cfNode, new int[]{index}, new Object[]{node});
                        } else if (node.getParent() instanceof DestinationFragmentTreeNode) {
                            AbstractTreeNode cleanupParent;
                            AbstractTreeNode cleanup = node;
                            do {
                                cleanupParent = (AbstractTreeNode)cleanup.getParent();
                                int index = cleanupParent.getIndex(cleanup);
                                cleanupParent.remove(cleanup);
                                BrowserTreeModel.this.nodesWereRemoved(cleanupParent, new int[]{index}, new Object[]{cleanup});
                            } while ((cleanup = cleanupParent).getChildCount() == 0 && cleanup instanceof DestinationFragmentTreeNode);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onHermesAdded(Hermes hermes) {
        try {
            HermesTreeNode node;
            int i;
            if (this.hermesMap.containsKey(hermes.getId())) {
                this.onHermesRemoved(hermes);
            }
            HermesTreeNode cfNode = new HermesTreeNode(hermes.getId(), hermes, this);
            HermesTreeNodeComparator comparator = new HermesTreeNodeComparator();
            this.hermesMap.put(hermes.getId(), cfNode);
            for (i = 0; i < this.jmsRootNode.getChildCount() && comparator.compare(cfNode, node = (HermesTreeNode)this.jmsRootNode.getChildAt(i)) >= 0; ++i) {
            }
            this.jmsRootNode.insert(cfNode, i);
            this.nodesWereInserted(this.jmsRootNode, new int[]{i});
        }
        catch (JMSException ex) {
            cat.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void onHermesRemoved(Hermes hermes) {
        if (this.hermesMap.containsKey(hermes.getId())) {
            HermesTreeNode cfNode = this.hermesMap.get(hermes.getId());
            int index = this.jmsRootNode.getIndex(cfNode);
            if (this.jmsRootNode.isNodeChild(cfNode)) {
                this.jmsRootNode.remove(cfNode);
                this.nodesWereRemoved(this.jmsRootNode, new int[]{index}, new Object[]{cfNode});
            }
            this.hermesMap.remove(hermes.getId());
            Iterator<DestinationConfigKeyWrapper> iter = this.destinationMap.keySet().iterator();
            while (iter.hasNext()) {
                DestinationConfigKeyWrapper key = iter.next();
                if (!key.getHermes().equals(hermes)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void onNamingAdded(NamingConfig namingConfig) {
        final NamingConfigTreeNode node = new NamingConfigTreeNode(namingConfig);
        this.namingNodeById.put(namingConfig.getId(), node);
        this.ctxRootNode.add(node);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BrowserTreeModel.this.ctxRootNode.getChildCount() == 0) {
                    BrowserTreeModel.this.nodeStructureChanged(BrowserTreeModel.this.ctxRootNode);
                } else {
                    BrowserTreeModel.this.nodesWereInserted(BrowserTreeModel.this.ctxRootNode, new int[]{BrowserTreeModel.this.ctxRootNode.getIndex(node)});
                }
            }
        });
    }

    @Override
    public void onNamingRemoved(NamingConfig namingConfig) {
        final NamingConfigTreeNode node = this.namingNodeById.get(namingConfig.getId());
        if (node != null) {
            final int index = this.ctxRootNode.getIndex(node);
            if (node != null) {
                if (this.ctxRootNode.isNodeChild(node)) {
                    this.ctxRootNode.remove(node);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BrowserTreeModel.this.nodesWereRemoved(BrowserTreeModel.this.ctxRootNode, new int[]{index}, new Object[]{node});
                        }
                    });
                }
                this.namingNodeById.remove(namingConfig.getId());
            }
        }
    }

    @Override
    public void onRepositoryAdded(HermesRepository repository) {
        final RepositoryTreeNode node = new RepositoryTreeNode(repository);
        this.rep2Node.put(repository, node);
        this.repositoryNode.add(node);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserTreeModel.this.nodesWereInserted(BrowserTreeModel.this.repositoryNode, new int[]{BrowserTreeModel.this.repositoryNode.getIndex(node)});
            }
        });
    }

    @Override
    public void onRepositoryRemoved(HermesRepository repository) {
        RepositoryTreeNode node = this.rep2Node.remove(repository);
        int index = this.repositoryNode.getIndex(node);
        this.rep2Node.remove(repository);
        this.repositoryNode.remove(node);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserTreeModel.this.nodeStructureChanged(BrowserTreeModel.this.repositoryNode);
            }
        });
    }

    public void onWatchAdded(WatchConfig watchConfig) {
    }

    public void onWatchRemoved(WatchConfig watchConfig) {
    }
}

