/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.swing.JideTabbedPane;
import hermes.Domain;
import hermes.HermesRuntimeException;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.BeanPropertyPanel;
import hermes.browser.dialog.JidePropertyImpl;
import hermes.config.DestinationConfig;
import hermes.config.PropertySetConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class DestinationPropertyConfigPanel
extends JPanel {
    private static final long serialVersionUID = 8657526639099576759L;
    private static final Logger log = Logger.getLogger(DestinationPropertyConfigPanel.class);
    private static final String NAME = "Name";
    private static final String SHORT_NAME = "ShortName";
    private static final String SELECTOR = "Selector";
    private static final String ISQUEUE = "Domain";
    private static final String DURABLE = "Durable";
    private static final String DURABLE_CLIENT = "DurableName";
    private static final String USERNAME = "Username";
    private static final String PASSWORD = "Password";
    private static final String NAME_INFO = "The name of the queue/topic or the binding in JNDI";
    private static final String SHORT_NAME_INFO = "An alterative name you may wish to use for display purposes, for example if the real name is too long";
    private static final String ISQUEUE_INFO = "The queue or the topic domain";
    private static final String DURABLE_INFO = "Make a durable subscription if a topic";
    private static final String DURABLE_CLIENT_INFO = "The subscription name to use if this is a durable subscription to a topic.";
    private static final String SELECTOR_INFO = "The selector to use when browsing from the queue or subscribing to the topic.";
    private static final String USERNAME_INFO = "Override the username from the sessions configuration";
    private static final String PASSWORD_INFO = "Override the password from the sessions configuration";
    private DestinationConfig config;
    private PropertyTable propertyTable;
    private PropertyTableModel propertyTableModel;
    private PropertyPane propertyPane;
    private Property nameProperty;
    private Property shortNameProperty;
    private Property selectorProperty;
    private Property domainProperty;
    private Property durableProperty;
    private Property durableClientIDProperty;
    private Property usernameProperty;
    private Property passwordProperty;
    private List onOK = new ArrayList();
    private Destination bean;
    private JideTabbedPane tabbedPane = new JideTabbedPane();
    private JPanel generalPanel = new JPanel();
    private BeanPropertyPanel beanPropertyPanel;

    public DestinationPropertyConfigPanel(String hermesId, Destination bean, DestinationConfig config) {
        try {
            this.bean = bean;
            this.config = config;
            Border border = BorderFactory.createBevelBorder(0);
            this.setLayout(new BorderLayout());
            this.add((Component)this.tabbedPane);
            this.generalPanel.setLayout(new BorderLayout());
            if (bean != null) {
                this.beanPropertyPanel = new BeanPropertyPanel(bean, true, false);
                this.beanPropertyPanel.init();
                this.beanPropertyPanel.setBorder(BorderFactory.createTitledBorder(border, "Provider Properties"));
            }
            this.generalPanel.setBorder(BorderFactory.createTitledBorder(border, "Hermes Properties"));
            this.tabbedPane.add("Hermes", (Component)this.generalPanel);
            if (bean != null) {
                this.tabbedPane.add("Provider", (Component)this.beanPropertyPanel);
            }
            this.tabbedPane.setTabPlacement(3);
            this.init();
        }
        catch (IllegalAccessException e) {
            throw new HermesRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new HermesRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HermesRuntimeException(e);
        }
    }

    public void init() {
        this.nameProperty = new JidePropertyImpl(NAME, NAME_INFO, String.class, this.config.getName());
        this.shortNameProperty = new JidePropertyImpl(SHORT_NAME, SHORT_NAME_INFO, String.class, this.config.getShortName());
        this.selectorProperty = new JidePropertyImpl(SELECTOR, SELECTOR_INFO, String.class, this.config.getSelector());
        this.domainProperty = new JidePropertyImpl(ISQUEUE, ISQUEUE_INFO, Domain.class, Domain.getDomain(this.config.getDomain()));
        this.durableProperty = new JidePropertyImpl(DURABLE, DURABLE_INFO, Boolean.class, this.config.isDurable());
        this.durableClientIDProperty = new JidePropertyImpl(DURABLE_CLIENT, DURABLE_CLIENT_INFO, String.class, this.config.getClientID());
        this.usernameProperty = new JidePropertyImpl(USERNAME, USERNAME_INFO, String.class, this.config.getUsername());
        this.passwordProperty = new JidePropertyImpl(PASSWORD, PASSWORD_INFO, String.class, this.config.getPassword());
        Runnable doOnOK = new Runnable(){

            public void run() {
                log.debug((Object)("config=" + DestinationPropertyConfigPanel.this.config));
                if (DestinationPropertyConfigPanel.this.nameProperty.getValue() != null && !DestinationPropertyConfigPanel.this.nameProperty.getValue().equals("")) {
                    DestinationPropertyConfigPanel.this.config.setName(DestinationPropertyConfigPanel.this.nameProperty.getValue().toString());
                }
                if (DestinationPropertyConfigPanel.this.shortNameProperty.getValue() != null && !DestinationPropertyConfigPanel.this.shortNameProperty.getValue().equals("")) {
                    DestinationPropertyConfigPanel.this.config.setShortName(DestinationPropertyConfigPanel.this.shortNameProperty.getValue().toString());
                } else {
                    DestinationPropertyConfigPanel.this.config.setShortName(null);
                }
                if (DestinationPropertyConfigPanel.this.selectorProperty.getValue() != null && !DestinationPropertyConfigPanel.this.selectorProperty.getValue().equals("")) {
                    DestinationPropertyConfigPanel.this.config.setSelector(DestinationPropertyConfigPanel.this.selectorProperty.getValue().toString());
                } else {
                    DestinationPropertyConfigPanel.this.config.setSelector(null);
                }
                if (DestinationPropertyConfigPanel.this.durableProperty.getValue() != null) {
                    DestinationPropertyConfigPanel.this.config.setDurable((boolean)((Boolean)DestinationPropertyConfigPanel.this.durableProperty.getValue()));
                }
                if (DestinationPropertyConfigPanel.this.domainProperty.getValue() != null) {
                    Domain domain = (Domain)DestinationPropertyConfigPanel.this.domainProperty.getValue();
                    DestinationPropertyConfigPanel.this.config.setDomain(domain.getId());
                }
                if (DestinationPropertyConfigPanel.this.durableClientIDProperty.getValue() != null && !DestinationPropertyConfigPanel.this.durableClientIDProperty.getValue().equals("")) {
                    DestinationPropertyConfigPanel.this.config.setClientID(DestinationPropertyConfigPanel.this.durableClientIDProperty.getValue().toString());
                } else {
                    DestinationPropertyConfigPanel.this.config.setClientID(null);
                }
                if (DestinationPropertyConfigPanel.this.usernameProperty.getValue() != null && !DestinationPropertyConfigPanel.this.usernameProperty.getValue().equals("")) {
                    DestinationPropertyConfigPanel.this.config.setUsername(DestinationPropertyConfigPanel.this.usernameProperty.getValue().toString());
                } else {
                    DestinationPropertyConfigPanel.this.config.setUsername(null);
                }
                if (DestinationPropertyConfigPanel.this.passwordProperty.getValue() != null && !DestinationPropertyConfigPanel.this.passwordProperty.getValue().equals("")) {
                    DestinationPropertyConfigPanel.this.config.setPassword(DestinationPropertyConfigPanel.this.passwordProperty.getValue().toString());
                } else {
                    DestinationPropertyConfigPanel.this.config.setPassword(null);
                }
            }
        };
        this.onOK.add(doOnOK);
        ArrayList<Property> model = new ArrayList<Property>();
        model.add(this.nameProperty);
        model.add(this.shortNameProperty);
        model.add(this.selectorProperty);
        model.add(this.domainProperty);
        model.add(this.durableProperty);
        model.add(this.durableClientIDProperty);
        model.add(this.usernameProperty);
        model.add(this.passwordProperty);
        this.propertyTableModel = new PropertyTableModel(model);
        this.propertyTable = new PropertyTable((TableModel)this.propertyTableModel);
        this.propertyTable.expandAll();
        this.propertyPane = new PropertyPane(this.propertyTable);
        this.generalPanel.add((Component)this.propertyPane, "Center");
    }

    public void doOK() {
        if (this.beanPropertyPanel != null) {
            log.debug((Object)("config=" + this.config));
            this.beanPropertyPanel.doOK();
            if (this.beanPropertyPanel.getChanges().size() > 0) {
                if (this.config.getProperties() == null) {
                    this.config.setProperties(new PropertySetConfig());
                }
                try {
                    HermesBrowser.getConfigDAO().updatePropertySet(this.config.getProperties(), this.beanPropertyPanel.getChanges());
                }
                catch (JAXBException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        for (Runnable r : this.onOK) {
            r.run();
        }
    }

    public void doCancel() {
    }

    public Class getPropertyType(String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.bean == null) {
            return String.class;
        }
        return PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)propertyName).getPropertyType();
    }

    public void addOKAction(Runnable r) {
        this.onOK.add(r);
    }
}

