/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.event.DockableFrameAdapter;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideScrollPane;
import hermes.Hermes;
import hermes.HermesException;
import hermes.HermesWatchListener;
import hermes.HermesWatchManager;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.components.WatchTable;
import hermes.browser.model.QueueWatchTableModel;
import hermes.browser.model.WatchInfo;
import hermes.config.DestinationConfig;
import hermes.config.WatchConfig;
import hermes.impl.DestinationConfigKeyWrapper;
import hermes.swing.SwingRunner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class WatchDockableFrame
extends DockableFrame
implements HermesWatchListener {
    private static final Timer flashingTimer = new Timer();
    private static final Logger log = Logger.getLogger(WatchDockableFrame.class);
    private static final long DEFAULT_AGE_ALERT = 0L;
    private static final int DEFAULT_DEPTH_ALERT = 0;
    private QueueWatchTableModel model;
    private WatchConfig config;
    private JPopupMenu popupMenu;
    private JMenuItem stopItem;
    private JMenuItem stopAllItem;
    private JMenuItem saveItem;
    private JMenuItem browseItem;
    private JMenuItem updateNow;
    private JMenuItem truncateItem;
    private JMenuItem expandAll;
    private JMenuItem collapseAll;
    private MouseAdapter mouseListener;
    private WatchTable table;
    private JideScrollPane tableScrollPane = new JideScrollPane();
    private boolean keepRunning = true;
    private boolean renaming = false;
    private TimerTask flashingTimerTask;
    private HermesWatchManager watchManager = new HermesWatchManager();

    public WatchDockableFrame(WatchConfig config) {
        super(config.getId(), (Icon)IconCache.getIcon("hermes.watch"));
        this.config = config;
        this.setAvailableButtons(29);
        this.getContext().setInitMode(4);
        this.getContext().setInitSide(4);
        this.flashingTimerTask = new TimerTask(){

            public void run() {
                WatchDockableFrame.this.maybeDoFlash();
            }
        };
        flashingTimer.schedule(this.flashingTimerTask, 1000L, 1000L);
        this.init();
    }

    public void close() {
        this.watchManager.close();
        this.model.removeAll();
        this.flashingTimerTask.cancel();
    }

    public void updateNow() {
        this.watchManager.updateNow();
    }

    public void updateConfig() {
        if (this.config.getUpdateFrequency() < 1000L) {
            this.config.setUpdateFrequency(1000L);
            Hermes.ui.getDefaultMessageSink().add("Minimum watch frequency is 1000ms");
        }
        this.config.getDestination().clear();
        this.config.getDestination().addAll(this.model.getDestinationWatchConfigs());
    }

    public void addWatch(Hermes hermes) {
        Iterator iter = hermes.getDestinations();
        while (iter.hasNext()) {
            DestinationConfig dConfig = (DestinationConfig)iter.next();
            this.addWatch(hermes.getId(), dConfig);
        }
    }

    public void removeWatch(String hermesId, String destinationName) {
        final WatchInfo info = this.model.findWatchInfo(hermesId, destinationName);
        if (info != null) {
            log.debug((Object)("removing hermesId=" + hermesId + " destinationName=" + destinationName));
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WatchDockableFrame.this.model.removeRow(info);
                    }
                });
            } else {
                this.model.removeRow(info);
            }
        } else {
            log.error((Object)("cannot remove hermesId=" + hermesId + " destinationName=" + destinationName));
        }
    }

    private void addWatch(String hermesId, DestinationConfig dConfig, int depthAlert, long ageAlert) {
        try {
            final WatchInfo info = new WatchInfo(hermesId, dConfig);
            Hermes hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(hermesId);
            info.setAgeAlert(ageAlert);
            info.setDepthAlert(depthAlert);
            this.watchManager.addWatch(hermes, dConfig, this);
            SwingRunner.invokeLater(new Runnable(){

                public void run() {
                    WatchDockableFrame.this.model.addRow(info);
                }
            });
        }
        catch (Exception ex) {
            log.error((Object)("in AddWatch(): " + ex.getMessage()), (Throwable)ex);
        }
    }

    public void addWatch(String hermesId, DestinationConfig dConfig) {
        this.addWatch(hermesId, dConfig, 0, 0L);
    }

    private void maybeDoFlash() {
        Runnable run = null;
        if (this.model != null && !this.model.hasAlert()) {
            run = new Runnable(){

                public void run() {
                    if (WatchDockableFrame.this.config != null) {
                        WatchDockableFrame.this.getDockingManager().denotifyFrame(WatchDockableFrame.this.config.getId());
                    }
                }
            };
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WatchDockableFrame.this.getDockingManager().notifyFrame(WatchDockableFrame.this.config.getId());
                }
            });
        }
        if (run != null) {
            SwingUtilities.invokeLater(run);
        }
    }

    private void init() {
        this.model = new QueueWatchTableModel();
        this.model.addColumn("Session");
        this.model.addColumn("Destination");
        this.model.addColumn("Durable");
        this.model.addColumn("Depth");
        this.model.addColumn("Oldest");
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                WatchDockableFrame.this.table.resort();
            }
        });
        this.table = new WatchTable(this.model, this.config.isShowAge());
        this.table.setComponentFactory(this.model);
        this.table.setSortable(true);
        this.table.getSelectionModel().setSelectionMode(2);
        this.mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    WatchDockableFrame.this.maybeDoPopup(e);
                }
            }

            public void mouseClicked(MouseEvent e) {
                WatchDockableFrame.this.maybeDoBrowse(e);
            }
        };
        this.getPopupMenu();
        this.table.addMouseListener(this.mouseListener);
        this.tableScrollPane.setViewportView((Component)((Object)this.table));
        this.tableScrollPane.addMouseListener((MouseListener)this.mouseListener);
        Iterator<DestinationConfig> iter = this.config.getDestination().iterator();
        while (iter.hasNext()) {
            try {
                DestinationConfig dConfig = iter.next();
                if (dConfig.getMyHermes() != null) {
                    this.addWatch(dConfig.getMyHermes(), dConfig, this.config.getDefaultDepthAlertThreshold(), this.config.getDefaultAgeAlertThreshold());
                    continue;
                }
                log.error((Object)"Discarded watch with a null Hermes");
            }
            catch (Exception e1) {
                log.error((Object)("could not start watch: " + e1.getMessage()), (Throwable)e1);
            }
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tableScrollPane);
        this.addDockableFrameListener((DockableFrameListener)new DockableFrameAdapter(){

            public void dockableFrameShown(DockableFrameEvent arg0) {
                log.debug((Object)("frame " + WatchDockableFrame.this.config.getId() + " visible, updating"));
                WatchDockableFrame.this.watchManager.updateNow();
            }
        });
    }

    public boolean doBrowse() {
        block5: {
            try {
                WatchInfo info = this.model.getRow(this.table.getActualRowAt(this.table.getSelectedRows()[0]));
                if (info == null) break block5;
                if (info.getE() == null) {
                    Hermes hermes = null;
                    try {
                        hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(info.getHermesId());
                    }
                    catch (NamingException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        HermesBrowser.getBrowser().showErrorDialog("Cannot browse: ", e);
                    }
                    HermesBrowser.getBrowser().getActionFactory().createQueueBrowseAction(hermes, info.getConfig());
                    return true;
                }
                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), "Cannot watch: " + info.getE().getClass().getName() + "\n" + info.getE().getMessage(), "Error", 0);
                return false;
            }
            catch (JMSException e1) {
                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), "Cannot browse: " + ((Object)((Object)e1)).getClass().getName() + "\n" + e1.getMessage(), "Error", 0);
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return false;
    }

    private boolean maybeDoBrowse(MouseEvent e) {
        if (e.getClickCount() == 2 && this.table.getSelectedRows().length == 1) {
            return this.doBrowse();
        }
        return false;
    }

    private boolean maybeDoPopup(MouseEvent e) {
        if (this.model.getRowCount() > 0) {
            if (this.table.getSelectedRows().length > 0) {
                this.stopItem.setEnabled(true);
                this.stopAllItem.setEnabled(true);
                this.browseItem.setEnabled(true);
                this.truncateItem.setEnabled(true);
            } else {
                this.stopItem.setEnabled(false);
                this.stopAllItem.setEnabled(false);
                this.browseItem.setEnabled(false);
                this.truncateItem.setEnabled(false);
            }
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            return true;
        }
        return false;
    }

    public void doTruncate() {
        if (this.table.getSelectedRows().length > 0) {
            for (int i = 0; i < this.table.getSelectedRows().length; ++i) {
                int row = this.table.getSelectedRows()[i];
                WatchInfo info = this.model.getRow(this.table.getActualRowAt(row));
                try {
                    Hermes hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(info.getHermesId());
                    HermesBrowser.getBrowser().getActionFactory().createTruncateAction(hermes, info.getConfig());
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)t.getMessage(), t);
                    HermesBrowser.getBrowser().showErrorDialog("Truncating " + info.getConfig().getName(), t);
                }
            }
        }
    }

    public void doStop() {
        int i;
        int[] rows = this.table.getSelectedRows();
        for (i = 0; i < rows.length; ++i) {
            rows[i] = this.table.getActualRowAt(rows[i]);
        }
        for (i = 0; i < rows.length; ++i) {
            WatchInfo wInfo = this.model.getRow(rows[i]);
            this.model.removeRow(rows[i]);
            try {
                Hermes hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(wInfo.getHermesId());
                log.debug((Object)("removing watch entry hermes=" + hermes.getId() + ", destination=" + wInfo.getConfig().getName()));
                this.watchManager.removeWatch(hermes, wInfo.getConfig().getName(), this);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void doStopAll() {
        this.model.removeAll();
        this.watchManager.clear();
    }

    public void doSave() {
        if (this.keepRunning) {
            try {
                this.updateConfig();
                HermesBrowser.getBrowser().saveConfig();
                Hermes.ui.getDefaultMessageSink().add("Watch config " + this.config.getId() + " saved.");
            }
            catch (HermesException e) {
                log.error((Object)e.getMessage(), (Throwable)((Object)e));
                JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Cannot save configuration: " + e.getMessage(), "Error", 0);
            }
        } else {
            log.error((Object)"cannot save, keepRunning=false");
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JidePopupMenu();
            this.stopItem = new JMenuItem("Remove");
            this.stopAllItem = new JMenuItem("Remove all");
            this.browseItem = new JMenuItem("Browse", IconCache.getIcon("hermes.browse"));
            this.truncateItem = new JMenuItem("Truncate", IconCache.getIcon("hermes.queue.truncate"));
            this.saveItem = new JMenuItem("Save", IconCache.getIcon("hermes.save"));
            this.updateNow = new JMenuItem("Update", IconCache.getIcon("hermes.update"));
            this.expandAll = new JMenuItem("Expand all", IconCache.getIcon("hermes.expand.all"));
            this.collapseAll = new JMenuItem("Collapse All", IconCache.getIcon("hermes.collapse.all"));
            this.popupMenu.add(this.stopItem);
            this.popupMenu.add(this.stopAllItem);
            this.popupMenu.add(this.saveItem);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.browseItem);
            this.popupMenu.add(this.updateNow);
            this.popupMenu.add(this.truncateItem);
            this.popupMenu.add(this.expandAll);
            this.popupMenu.add(this.collapseAll);
            this.truncateItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    WatchDockableFrame.this.doTruncate();
                }
            });
            this.updateNow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WatchDockableFrame.this.watchManager.updateNow();
                }
            });
            this.stopItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WatchDockableFrame.this.doStop();
                }
            });
            this.stopAllItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WatchDockableFrame.this.doStopAll();
                }
            });
            this.saveItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WatchDockableFrame.this.doSave();
                }
            });
            this.browseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WatchDockableFrame.this.doBrowse();
                }
            });
            this.collapseAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    WatchDockableFrame.this.table.collapseAllRows();
                }
            });
            this.expandAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    WatchDockableFrame.this.table.expandAllRows();
                }
            });
        }
        return this.popupMenu;
    }

    public MouseAdapter getMouseListener() {
        return this.mouseListener;
    }

    public WatchConfig getConfig() {
        return this.config;
    }

    public String getHighlighedTitle() {
        return "<html><b><font color=\"red\">" + this.config.getId() + "</font></b></html>";
    }

    public String getPlainTitle() {
        return this.config.getId();
    }

    private WatchInfo getWatchInfo(Hermes hermes, DestinationConfig dConfig) throws JMSException {
        return this.model.getRowByKey(new DestinationConfigKeyWrapper(dConfig));
    }

    public void onDepthChange(Hermes hermes, DestinationConfig dConfig, long depth) {
        try {
            WatchInfo info = this.getWatchInfo(hermes, dConfig);
            info.setDepth((int)depth);
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onException(Hermes hermes, DestinationConfig dConfig, Exception e) {
        try {
            WatchInfo info = this.getWatchInfo(hermes, dConfig);
            info.setE(e);
            this.setTabTitle(this.getTitle());
            this.repaint();
        }
        catch (JMSException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void onOldestMessageChange(Hermes hermes, DestinationConfig dConfig, Date oldest) {
        try {
            WatchInfo info = this.getWatchInfo(hermes, dConfig);
            if (oldest != null) {
                info.setOldest(oldest.getTime());
            } else {
                info.setOldest(0L);
            }
        }
        catch (JMSException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void onPropertyChange(Hermes hermes, DestinationConfig dConfig, Map properties) {
        try {
            WatchInfo info = this.getWatchInfo(hermes, dConfig);
            info.setStatistics(properties);
            this.repaint();
        }
        catch (JMSException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

