/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import com.codestreet.selector.parser.InvalidSelectorException;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.ListSelectionModelGroup;
import com.jidesoft.grid.TreeLikeHierarchicalPanel;
import hermes.HermesRuntimeException;
import hermes.browser.actions.AbstractFIXBrowserDocumentComponent;
import hermes.browser.actions.FilterableAction;
import hermes.browser.components.FitScrollPane;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageTable;
import hermes.fix.FIXMessageTableModel;
import hermes.fix.FIXSessionTable;
import hermes.fix.FIXSessionTableModel;
import hermes.fix.SessionKey;
import hermes.fix.quickfix.QuickFIXMessageCache;
import hermes.swing.ProxyListSelectionModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIXSessionBrowserDocumentComponent
extends AbstractFIXBrowserDocumentComponent
implements HierarchicalTableComponentFactory,
FilterableAction {
    private static final Logger log = Logger.getLogger(FIXSessionBrowserDocumentComponent.class);
    private boolean firstMessage = true;
    private ListSelectionEvent lastSelected;
    private final ListSelectionModelGroup listSelectionGroup = new ListSelectionModelGroup();
    private final Map<SessionKey, FIXMessageTable> tables = new HashMap<SessionKey, FIXMessageTable>();
    private FIXSessionTable sessionTable;
    private FIXSessionTableModel sessionTableModel = new FIXSessionTableModel();
    private ListSelectionListener sessionTableListSelectionListener;
    private TableModelListener sessionTableModelListener;
    private JPopupMenu popup;
    private Map<FIXMessageTable, ListSelectionListener> childTableListSelectionListeners = new HashMap<FIXMessageTable, ListSelectionListener>();
    private SessionKey selectedSessionKey;
    private ProxyListSelectionModel proxySelectionModel = new ProxyListSelectionModel();
    private QuickFIXMessageCache messageCache = new QuickFIXMessageCache();

    public FIXSessionBrowserDocumentComponent(String title) {
        super(title);
        this.sessionTable = new FIXSessionTable(this.sessionTableModel);
        this.sessionTable.setComponentFactory(this);
        this.init();
    }

    @Override
    public ListSelectionModel getListSelectionModel() {
        return this.proxySelectionModel;
    }

    @Override
    public boolean isNavigableForward() {
        if (this.selectedSessionKey != null) {
            FIXMessageTable table = this.tables.get(this.selectedSessionKey);
            return table.getSelectedRow() < table.getRowCount() - 1;
        }
        return false;
    }

    @Override
    public boolean isNavigableBackward() {
        if (this.selectedSessionKey != null) {
            FIXMessageTable table = this.tables.get(this.selectedSessionKey);
            return table.getSelectedRow() > 0 && table.getRowCount() > 1;
        }
        return false;
    }

    @Override
    public void navigateBackward() {
        if (this.selectedSessionKey != null) {
            FIXMessageTable table = this.tables.get(this.selectedSessionKey);
            int currentRow = table.getSelectedRow();
            table.getSelectionModel().setSelectionInterval(currentRow - 1, currentRow - 1);
        }
    }

    @Override
    public void navigateForward() {
        if (this.selectedSessionKey != null) {
            FIXMessageTable table = this.tables.get(this.selectedSessionKey);
            int currentRow = table.getSelectedRow();
            table.getSelectionModel().setSelectionInterval(currentRow + 1, currentRow + 1);
        }
    }

    @Override
    public Collection<Object> getSelectedMessages() {
        if (this.selectedSessionKey != null) {
            FIXMessageTable table = this.tables.get(this.selectedSessionKey);
            return table.getSelectedMessages();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.sessionTable.getModel().removeTableModelListener(this.sessionTableModelListener);
        this.sessionTable.getSelectionModel().removeListSelectionListener(this.sessionTableListSelectionListener);
        for (Map.Entry<FIXMessageTable, ListSelectionListener> entry : this.childTableListSelectionListeners.entrySet()) {
            this.listSelectionGroup.remove((Object)entry.getKey().getSelectionModel());
            entry.getKey().getSelectionModel().removeListSelectionListener(entry.getValue());
        }
        this.sessionTable.close();
        this.sessionTable = null;
        this.messageCache.close();
        for (DocumentComponentListener l : this.getDocumentComponentListeners()) {
            this.removeDocumentComponentListener(l);
        }
    }

    public void decrementSelection() {
        int currentRow = this.sessionTable.getSelectedRow();
        this.sessionTable.getSelectionModel().setSelectionInterval(currentRow - 1, currentRow - 1);
    }

    public void incrementSelection() {
        int currentRow = this.sessionTable.getSelectedRow();
        this.sessionTable.getSelectionModel().setSelectionInterval(currentRow + 1, currentRow + 1);
    }

    public boolean hasSelection() {
        return this.sessionTable.getSelectedRowCount() > 0;
    }

    @Override
    public void setSelector(String selector) throws InvalidSelectorException {
        for (FIXMessageTable table : this.tables.values()) {
            table.setSelector(selector);
        }
    }

    public synchronized Component createChildComponent(HierarchicalTable table, Object value, int row) {
        FIXMessageTableModel model = (FIXMessageTableModel)value;
        if (model == null) {
            throw new HermesRuntimeException("No table");
        }
        FIXMessageTable childTable = null;
        SessionKey sessionKey = this.sessionTableModel.getSessionKey(row);
        if (this.tables.containsKey(sessionKey)) {
            childTable = this.tables.get(sessionKey);
        } else {
            childTable = new FIXMessageTable(sessionKey, model);
            this.tables.put(this.sessionTableModel.getSessionKey(row), childTable);
            final FIXMessageTable fChildTable = childTable;
            this.proxySelectionModel.add(childTable.getSelectionModel());
            ListSelectionListener childTableListSelectionListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    FIXSessionBrowserDocumentComponent.this.doSelectionChanged(fChildTable, e);
                }
            };
            childTable.getSelectionModel().addListSelectionListener(childTableListSelectionListener);
            this.childTableListSelectionListeners.put(childTable, childTableListSelectionListener);
        }
        FitScrollPane fitPane = new FitScrollPane((Component)((Object)childTable));
        TreeLikeHierarchicalPanel hPanel = new TreeLikeHierarchicalPanel((Component)fitPane);
        this.listSelectionGroup.add((Object)childTable.getSelectionModel());
        return hPanel;
    }

    @Override
    public void doSelectionChanged(FIXMessageTable table, ListSelectionEvent e) {
        super.doSelectionChanged(table, e);
    }

    public synchronized void destroyChildComponent(HierarchicalTable table, Component component, int row) {
        FIXMessageTable childTable = this.tables.get(this.sessionTableModel.getSessionKey(row));
        this.listSelectionGroup.remove((Object)childTable.getSelectionModel());
        this.proxySelectionModel.remove(childTable.getSelectionModel());
    }

    @Override
    protected Component getHeaderComponent() {
        return this.sessionTable;
    }

    @Override
    protected void init() {
        super.init();
        this.sessionTableModelListener = new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    log.debug((Object)("faking createChildComponent for row " + e.getFirstRow()));
                    FIXSessionBrowserDocumentComponent.this.createChildComponent(FIXSessionBrowserDocumentComponent.this.sessionTable, FIXSessionBrowserDocumentComponent.this.sessionTable.getChildValueAt(e.getFirstRow()), e.getFirstRow());
                }
            }
        };
        this.sessionTable.getModel().addTableModelListener(this.sessionTableModelListener);
        this.sessionTableListSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (FIXSessionBrowserDocumentComponent.this.sessionTable.getSelectedRow() >= 0 && FIXSessionBrowserDocumentComponent.this.sessionTable.getSelectedRow() < FIXSessionBrowserDocumentComponent.this.sessionTable.getRowCount()) {
                    FIXSessionBrowserDocumentComponent.this.selectedSessionKey = FIXSessionBrowserDocumentComponent.this.sessionTable.getSessionKey(FIXSessionBrowserDocumentComponent.this.sessionTable.getSelectedRow());
                    FIXSessionBrowserDocumentComponent.this.proxySelectionModel.forward(e);
                }
            }
        };
        this.sessionTable.getSelectionModel().addListSelectionListener(this.sessionTableListSelectionListener);
    }

    @Override
    protected void updateTableRows(final boolean reschedule) {
        if (this.sessionTable == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Collection<FIXMessage> collection = FIXSessionBrowserDocumentComponent.this.getCachedRows();
                synchronized (collection) {
                    if (FIXSessionBrowserDocumentComponent.this.sessionTable != null) {
                        FIXSessionBrowserDocumentComponent.this.sessionTable.addMessages(FIXSessionBrowserDocumentComponent.this.getCachedRows());
                        if (FIXSessionBrowserDocumentComponent.this.firstMessage) {
                            FIXSessionBrowserDocumentComponent.this.sessionTable.getSelectionModel().setSelectionInterval(0, 0);
                            FIXSessionBrowserDocumentComponent.this.firstMessage = false;
                        }
                        FIXSessionBrowserDocumentComponent.this.setCachedRows(new ArrayList<FIXMessage>());
                    }
                }
                StringBuffer buffer = new StringBuffer();
                if (!reschedule || FIXSessionBrowserDocumentComponent.this.isTaskStopped()) {
                    buffer.append("Finished. ");
                } else {
                    switch (FIXSessionBrowserDocumentComponent.this.sessionTableModel.getRowCount()) {
                        case 0: {
                            buffer.append("No sessions found.");
                            break;
                        }
                        case 1: {
                            buffer.append("1 session found.");
                            break;
                        }
                        default: {
                            buffer.append(FIXSessionBrowserDocumentComponent.this.sessionTableModel.getRowCount()).append(" sessions found.");
                        }
                    }
                }
                if (reschedule) {
                    FIXSessionBrowserDocumentComponent.this.setStatusText(buffer.toString());
                } else {
                    FIXSessionBrowserDocumentComponent.this.setStatusText("Finished. " + buffer.toString());
                }
                if (reschedule) {
                    TimerTask timerTask = new TimerTask(){

                        public void run() {
                            FIXSessionBrowserDocumentComponent.this.updateTableRows(true);
                        }
                    };
                    AbstractFIXBrowserDocumentComponent.timer.schedule(timerTask, FIXSessionBrowserDocumentComponent.this.getScreenUpdateTimeout());
                }
            }
        });
    }

    public QuickFIXMessageCache getMessageCache() {
        return this.messageCache;
    }
}

