/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.imq;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.imq.ImqAdminFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImqAdmin
extends HermesAdminSupport
implements HermesAdmin,
MessageListener {
    static final String DEST_LIST_TOPIC_NAME = "mq.metrics.destination_list";
    static final String QUEUE_METRICS_TOPIC_PREFIX = "mq.metrics.destination.queue.";
    static final String TOPIC_METRICS_TOPIC_PREFIX = "mq.metrics.destination.topic.";
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private MessageConsumer destListTopicSubscriber;
    private Map<String, MessageConsumer> destMetricTopicSubscribers = new HashMap<String, MessageConsumer>();
    private Map<String, Long> messageCounts = new HashMap<String, Long>();
    private Map<String, Map<String, Long>> stats = new HashMap<String, Map<String, Long>>();
    private List<DestinationConfig> destinations = new ArrayList<DestinationConfig>();
    private static Log LOG = LogFactory.getLog(ImqAdminFactory.class);
    private Object destListGuard = new Object();
    private Object destMetricGuard = new Object();

    public ImqAdmin(Hermes hermes, ConnectionFactory connectionFactory) {
        super(hermes);
        this.connectionFactory = connectionFactory;
        LOG.debug((Object)"Building ImqAdmin");
        try {
            this.connection = this.connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            Topic destListTopic = this.session.createTopic(DEST_LIST_TOPIC_NAME);
            this.destListTopicSubscriber = this.session.createConsumer((Destination)destListTopic);
            this.destListTopicSubscriber.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DestinationConfig> discoverDestinationConfigs() throws JMSException {
        LOG.debug((Object)"Discovering destination(s)");
        try {
            Object object = this.destListGuard;
            synchronized (object) {
                this.destListGuard.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug((Object)("Discovered " + this.destinations.size() + " destination(s)"));
        return this.destinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDepth(DestinationConfig destinationConfig) throws JMSException {
        LOG.debug((Object)"Getting depth");
        try {
            this.subscribeToDestMetricTopic(destinationConfig.getShortName(), destinationConfig.getDomain());
            Object object = this.destMetricGuard;
            synchronized (object) {
                this.destMetricGuard.wait(5000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Long result = this.messageCounts.get(destinationConfig.getShortName());
        LOG.debug((Object)("Got depth for " + destinationConfig.getShortName() + ": " + result));
        if (result == null) {
            throw new RuntimeException("Timeout: Got no data from metric topic.");
        }
        this.clearDestMetricTopicSubscribers();
        return result.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getStatistics(DestinationConfig destination) throws JMSException {
        LOG.debug((Object)("Getting statistics for " + destination));
        try {
            Object object = this.destMetricGuard;
            synchronized (object) {
                this.subscribeToDestMetricTopic(destination.getShortName(), destination.getDomain());
                this.destMetricGuard.wait(5000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Map<String, Long> result = this.stats.get(destination.getShortName());
        this.clearDestMetricTopicSubscribers();
        if (result == null) {
            throw new RuntimeException("Timeout: Got no data from metric topic.");
        }
        return result;
    }

    public void close() throws JMSException {
        LOG.debug((Object)"Closing IMQ Session");
        this.clearDestMetricTopicSubscribers();
        this.destListTopicSubscriber.close();
        this.session.close();
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block16: {
            try {
                MapMessage mapMsg = (MapMessage)msg;
                String type = mapMsg.getStringProperty("type");
                LOG.debug((Object)("Got admin message from broker of type: " + type));
                if (type.equals(DEST_LIST_TOPIC_NAME)) {
                    ArrayList<DestinationConfig> result = new ArrayList<DestinationConfig>();
                    Object e = mapMsg.getMapNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        Map object = (Map)mapMsg.getObject(name);
                        DestinationConfig dest = HermesBrowser.getConfigDAO().createDestinationConfig();
                        dest.setName((String)object.get("name"));
                        dest.setShortName((String)object.get("name"));
                        dest.setDomain(Integer.valueOf("queue".equals(object.get("type")) ? Domain.QUEUE.getId() : ("queue".equals(object.get("topic")) ? Domain.TOPIC.getId() : Domain.UNKNOWN.getId())));
                        result.add(dest);
                    }
                    Collections.sort(result, new Comparator<DestinationConfig>(){

                        @Override
                        public int compare(DestinationConfig o1, DestinationConfig o2) {
                            return o1.getShortName().compareTo(o2.getShortName());
                        }
                    });
                    this.destinations = result;
                    e = this.destListGuard;
                    synchronized (e) {
                        this.destListGuard.notifyAll();
                        break block16;
                    }
                }
                if (type.startsWith(QUEUE_METRICS_TOPIC_PREFIX)) {
                    Object name;
                    LOG.debug((Object)("Got queue metrics: " + type));
                    String queueName = type.substring(QUEUE_METRICS_TOPIC_PREFIX.length());
                    this.messageCounts.put(queueName, mapMsg.getLong("numMsgs"));
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    Enumeration e = mapMsg.getMapNames();
                    while (e.hasMoreElements()) {
                        name = (String)e.nextElement();
                        map.put((String)name, mapMsg.getLong((String)name));
                    }
                    this.stats.put(queueName, map);
                    LOG.debug((Object)("Stored stats for: " + queueName));
                    name = this.destMetricGuard;
                    synchronized (name) {
                        this.destMetricGuard.notifyAll();
                        break block16;
                    }
                }
                if (!type.startsWith(TOPIC_METRICS_TOPIC_PREFIX)) break block16;
                LOG.debug((Object)("Got topic metrics: " + type));
                String topicName = type.substring(TOPIC_METRICS_TOPIC_PREFIX.length());
                this.messageCounts.put(topicName, mapMsg.getLong("numMsgs"));
                HashMap<String, Long> map = new HashMap<String, Long>();
                Enumeration e = mapMsg.getMapNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    map.put(name, mapMsg.getLong(name));
                }
                this.stats.put(topicName, map);
                LOG.debug((Object)("Stored stats for: " + topicName));
                Object object = this.destMetricGuard;
                synchronized (object) {
                    this.destMetricGuard.notifyAll();
                }
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private MessageConsumer subscribeToDestMetricTopic(String destName, int domain) throws JMSException {
        LOG.debug((Object)("Subscribing to " + destName));
        String topicName = null;
        if (domain == Domain.QUEUE.getId()) {
            topicName = QUEUE_METRICS_TOPIC_PREFIX + destName;
        } else if (domain == Domain.TOPIC.getId()) {
            topicName = TOPIC_METRICS_TOPIC_PREFIX + destName;
        }
        Topic destListTopic = this.session.createTopic(topicName);
        MessageConsumer subscriber = this.session.createConsumer((Destination)destListTopic);
        subscriber.setMessageListener((MessageListener)this);
        LOG.debug((Object)("Created subscriber " + subscriber + " listening to " + topicName));
        return subscriber;
    }

    private void clearDestMetricTopicSubscribers() throws JMSException {
        for (MessageConsumer subscriber : this.destMetricTopicSubscribers.values()) {
            LOG.debug((Object)("Closing subscriber: " + subscriber));
            subscriber.close();
        }
        this.destMetricTopicSubscribers.clear();
    }
}

